// -*- coding: iso-8859-1-unix -*-
#ifndef PROTOCOL_V1_04_01_H_
#define PROTOCOL_V1_04_01_H_

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
# pragma once
#endif

#include <boost/cstdint.hpp>
#include <vector>
#include <climits>
#include <limits>

namespace tecgraf { namespace ftc { namespace v1_04_01
{
  namespace protocol
  {
    typedef uint64_t long_t;
    typedef uint32_t int_t;
    typedef uint16_t short_t;
    typedef uint8_t byte_t;

    static const unsigned int long_size = sizeof(long_t);
    static const unsigned int int_size = sizeof(int_t);
    static const unsigned int short_size = sizeof(short_t);
    static const unsigned int byte_size = sizeof(byte_t);

    static const byte_t major_version = 1U;
    static const byte_t minor_version = 4U;
    static const byte_t patch_version = 0U;
    static const byte_t v2_minor_version = 2U;

    static const byte_t STATUS_SUCCESS = 0x00;
    static const byte_t STATUS_FAILURE = 0x01;
    static const byte_t STATUS_UNKNOWN = 0xFF;

    static const char protocol_identification[] = {0, 'F', 'T', 'C'};
    static const char version_identification[] = {0, major_version, minor_version, patch_version};

    static const long_t CURRENT_POSITION = std::numeric_limits<long_t>::max();

    union Version {
      struct {
        uint8_t padding;
        uint8_t major;
        uint8_t minor;
        uint8_t patch;
      };
      uint32_t value;
    };

    namespace Operations
    {
      /**
      * @brief Representa uma operao que pode ser realizada num canal FTC.
      */
      enum Operation
      {
        /**
        * @brief Operao de abertura de um arquivo somente para leitura.
        */
        OPEN_READ_ONLY = 0,
        /**
        * @brief Operao de abertura de um arquivo para leitura e para gravao.
        */
        OPEN_READ_WRITE = 1,
        /**
        * @brief Operao de fechamento de um arquivo.
        */
        CLOSE = 2,
        /**
        * @brief Operao para truncar o arquivo para um novo tamanho.
        */
        SET_SIZE = 3,
        /**
        * @brief Operao de obteno da posio atual do arquivo.
        */
        GET_POSITION = 4,
        /**
        * @brief Operao para definir a nova posio do arquivo.
        */
        SET_POSITION = 5,
        /**
        * @brief Operao de obteno do tamanho do arquivo.
        */
        GET_SIZE = 6,
        /**
        * @brief Operao para leitura de dados.
        */
        READ = 7,
        /**
        * @brief Operao para escrita de dados.
        */
        WRITE = 8,
        /**
        * @brief Operao para manter a conexao ativa.
        */
        KEEP_ALIVE = 9
      };
    }
  }
}}}

#endif

