// -*- coding: iso-8859-1-unix -*-
#ifndef SOCKETCHANNEL_V1_04_01_H_
#define SOCKETCHANNEL_V1_04_01_H_

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
# pragma once
#endif

#include "ftc/StreamDataChannel.h"
#include "ftc/FTCException.h"
#include "ftc/Writer.h"

#include <boost/asio.hpp>

namespace tecgraf { namespace ftc { namespace v1_04_01 {

  class Buffer;
  class Connection;

  class OutputSocketChannel : public StreamDataChannel
  {
  public:
    OutputSocketChannel(Writer& output);
    virtual ~OutputSocketChannel();

    /// @copydoc IDataChannel::supportedOperations()
    virtual uint16_t supportedOperations() const
    { return (Operations::write); }
    /// @copydoc IDataChannel::isOpen()
    virtual bool isOpen() const;
    /// @copydoc IDataChannel::remaining()
    virtual int64_t remaining() const;

    /// @copydoc IDataChannel::write(Buffer&)
    virtual int64_t write(Buffer& source);

    Connection& connection();
  protected:
    Writer& output;
    Connection& conn;
  };

} } }

#endif

