// -*- coding: iso-8859-1-unix -*-
#ifndef LOG_V1_04_01_H_
#define LOG_V1_04_01_H_

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
# pragma once
#endif

#ifdef FTC_STATIC_DISABLE_LOG
#define FTC_LOG_FATAL(x) do {} while(false)
#define FTC_LOG_ERROR(x) do {} while(false)
#define FTC_LOG_WARN(x) do {} while(false)
#define FTC_LOG_INFO(x) do {} while(false)
#define FTC_LOG_DEBUG(x) do {} while(false)
#define FTC_LOG_TRACE(x) do {} while(false)
#else

#include "ftc/ServerConfig.h"

#include <string>
#include <ostream>
#include <sstream>

#include <boost/thread.hpp>
#include <boost/date_time/posix_time/posix_time.hpp>
#include <boost/date_time/time_facet.hpp>

namespace tecgraf { namespace ftc { namespace v1_04_01
{
  /**
  * @brief Classe responsvel por fazer o log do FTC
  *
  * @author Tecgraf/Puc-Rio
  */
  struct FtcLog
  {
    /**
    * @brief Construtor
    */
    FtcLog();

    /**
    * @brief Destrutor
    */
    ~FtcLog();

    /**
    * @brief Liga o log de acordo com as configuraes passadas.
    */
    void enable(const ServerConfig& config);

    /// Mutex para impedir dois threads tentarem escrever ao mesmo tempo no arquivo
    boost::mutex mutex;
    /// Stream de sada do log
    std::ostream* ostream;
    /// Indica se o stream de sada existe
    bool enabled;
    /// arquivo de sada do log
    std::string filename;
    /// nvel de log
    ServerConfig::ServerLogLevel level;
    /// Indica se faz o log da data e hora
    bool log_date_time;
  };

  extern FtcLog ftcLog;

}}}

#ifndef FTC_LOG_OSTREAM
#define FTC_LOG_OSTREAM()  (* ::tecgraf::ftc::v1_04_01::ftcLog.ostream)
#endif

#ifndef FTC_LOG_GUARD
#define FTC_LOG_GUARD(L, T, X) do {                                                                  \
    if( !::tecgraf::ftc::v1_04_01::ftcLog.enabled )                                                  \
      break;                                                                                         \
                                                                                                     \
    if( ::tecgraf::ftc::v1_04_01::ftcLog.level < L )                                                 \
      break;                                                                                         \
                                                                                                     \
    if (::tecgraf::ftc::v1_04_01::ftcLog.log_date_time) {                                            \
      boost::posix_time::ptime now = boost::posix_time::second_clock::local_time();                  \
      boost::posix_time::time_facet* facet(new boost::posix_time::time_facet("%d/%m/%Y %H:%M:%S ")); \
      boost::unique_lock<boost::mutex> lock(::tecgraf::ftc::v1_04_01::ftcLog.mutex);                 \
      FTC_LOG_OSTREAM().imbue(std::locale(FTC_LOG_OSTREAM().getloc(), facet));                       \
      FTC_LOG_OSTREAM() << now << T << X;                                                            \
    } else {                                                                                         \
      boost::unique_lock<boost::mutex> lock(::tecgraf::ftc::v1_04_01::ftcLog.mutex);                 \
      FTC_LOG_OSTREAM() << T << X;                                                                   \
    }                                                                                                \
  } while(false)
#endif

#define FTC_LOG_FATAL(X) FTC_LOG_GUARD( ::tecgraf::ftc::v1_04_01::ServerConfig::LOG_FATAL, "FATAL - ", X)
#define FTC_LOG_ERROR(X) FTC_LOG_GUARD( ::tecgraf::ftc::v1_04_01::ServerConfig::LOG_ERROR, "ERROR - ", X)
#define FTC_LOG_WARN(X) FTC_LOG_GUARD( ::tecgraf::ftc::v1_04_01::ServerConfig::LOG_WARN, "WARN - ", X)
#define FTC_LOG_INFO(X) FTC_LOG_GUARD( ::tecgraf::ftc::v1_04_01::ServerConfig::LOG_INFO, "INFO - ", X)
#define FTC_LOG_DEBUG(X) FTC_LOG_GUARD( ::tecgraf::ftc::v1_04_01::ServerConfig::LOG_DEBUG, "DEBUG - ", X)
#define FTC_LOG_TRACE(X) FTC_LOG_GUARD( ::tecgraf::ftc::v1_04_01::ServerConfig::LOG_TRACE, "TRACE - ", X)

#endif

#endif

