// -*- coding: iso-8859-1-unix -*-
#ifndef FILECHANNEL_V1_04_01_H_
#define FILECHANNEL_V1_04_01_H_

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
# pragma once
#endif

#include "ftc/IDataChannel.h"

#include <string>
#include <boost/shared_ptr.hpp>

namespace tecgraf { namespace ftc { namespace v1_04_01 {

  /**
  * @brief Implementao para criar uma canal de dados  partir de um arquivo
  *
  * @author Tecgraf/PUC-Rio
  */
  class FileChannel : public IDataChannel
  {
  public:
    /**
    * @brief Construtor
    * @param filename Nome do arquivo para ser criado/aberto
    * @param read_only Indica se abre como somente leitura
    */
    FileChannel(const std::string& filename, bool read_only);

    /**
    * @brief Destrutor
    */
    virtual ~FileChannel();

    /// @copydoc IDataChannel::supportedOperations()
    virtual uint16_t supportedOperations() const;

    /// @copydoc IDataChannel::isOpen()
    virtual bool isOpen() const;
    /// @copydoc IDataChannel::remaining()
    virtual int64_t remaining() const;
    /// @copydoc IDataChannel::skip()
    virtual uint64_t skip(const uint64_t count);

    /// @copydoc IDataChannel::read(Buffer&)
    virtual int64_t read(Buffer& dest);
    /// @copydoc IDataChannel::read(Buffer&, const uint64_t)
    virtual int64_t read(Buffer& dest, const uint64_t remotePosition);

    /// @copydoc IDataChannel::write(Buffer&)
    virtual int64_t write(Buffer& source);
    /// @copydoc IDataChannel::write(Buffer&, const uint64_t)
    virtual int64_t write(Buffer& source, const uint64_t remotePosition);

    /// @copydoc IDataChannel::size()
    virtual uint64_t size() const;
    /// @copydoc IDataChannel::size(const uint64_t)
    virtual void size(const uint64_t size);

    /// @copydoc IDataChannel::position()
    virtual uint64_t position() const;
    /// @copydoc IDataChannel::position(const uint64_t)
    virtual void position(const uint64_t position);

    /// @copydoc IDataChannel::transferTo()
    virtual int64_t transferTo(const uint64_t remotePosition, const uint64_t nbytes, IDataChannel& dest);
    /// @copydoc IDataChannel::transferFrom()
    virtual int64_t transferFrom(IDataChannel& source, const uint64_t remotePosition, const uint64_t nbytes);
  private:
    class impl;
    boost::shared_ptr<impl> impl_ptr;
  };

}}}

#endif

