// -*- coding: iso-8859-1-unix -*-
#ifndef FTCSESSION_V1_04_01_H_
#define FTCSESSION_V1_04_01_H_

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
# pragma once
#endif

#include "ftc/states/SupportedProtocols.h"
#include "ftc/ServerConfig.h"
#include "ftc/FTCException.h"
#include "ftc/states/v1_4/CloseState.h"
#include "ftc/states/v1_4/GetOperationState.h"
#include "ftc/states/v1_4/GetPositionState.h"
#include "ftc/states/v1_4/GetSizeState.h"
#include "ftc/states/v1_4/KeepAliveState.h"
#include "ftc/states/v1_4/OpenState.h"
#include "ftc/states/v1_4/ReadState.h"
#include "ftc/states/v1_4/SetPositionState.h"
#include "ftc/states/v1_4/SetSizeState.h"
#include "ftc/states/v1_4/ValidateKeyState.h"
#include "ftc/states/v1_4/VersionHandshakeState.h"
#include "ftc/states/v1_4/WriteState.h"
#include "ftc/states/v1_2/CloseState.h"
#include "ftc/states/v1_2/GetOperationState.h"
#include "ftc/states/v1_2/GetPositionState.h"
#include "ftc/states/v1_2/GetSizeState.h"
#include "ftc/states/v1_2/KeepAliveState.h"
#include "ftc/states/v1_2/OpenState.h"
#include "ftc/states/v1_2/ReadState.h"
#include "ftc/states/v1_2/SetPositionState.h"
#include "ftc/states/v1_2/SetSizeState.h"
#include "ftc/states/v1_2/ValidateKeyState.h"
#include "ftc/states/v1_2/WriteState.h"
#include "ftc/states/v1_1/CloseState.h"
#include "ftc/states/v1_1/GetOperationState.h"
#include "ftc/states/v1_1/GetPositionState.h"
#include "ftc/states/v1_1/GetSizeState.h"
#include "ftc/states/v1_1/OpenState.h"
#include "ftc/states/v1_1/ReadState.h"
#include "ftc/states/v1_1/SetPositionState.h"
#include "ftc/states/v1_1/SetSizeState.h"
#include "ftc/states/v1_1/ValidateKeyState.h"
#include "ftc/states/v1_1/WriteState.h"
#include "ftc/Buffer.h"
#include "ftc/BaseSession.h"
#include "ftc/ChannelClosedReason.h"
#include "ftc/IDataChannel.h"
#include "ftc/Log.h"
#include "ftc/DataChannelInfo.h"

#include <boost/asio.hpp>
#include <boost/variant.hpp>
#include <boost/mpl/vector.hpp>
#include <boost/mpl/vector/vector40.hpp>

#include <stdexcept>

namespace tecgraf { namespace ftc { namespace v1_04_01 {  

  namespace states { class State; }

  class FTCServer;
  class Connection;
  class FTCServerConfig;

  class FTCSession : public BaseSession
  {
  public:
    FTCSession(FTCServer& server, const FTCServerConfig& config, Connection& socket);
    virtual ~FTCSession();

    virtual bool want_read() const;
    virtual bool do_read(boost::system::error_code& ec);
    virtual bool want_write() const;
    virtual bool do_write(boost::system::error_code& ec);

    template <class T>
    void setCurrentState()
    {
      m_states = T();
      state = &boost::get<T>(m_states);
      FTC_LOG_INFO("Estado: " << typeid(*state).name() << std::endl); 
    };

    template <class T, typename P1>
    void setCurrentState(P1 p)
    {
      m_states = T(p);
      state = &boost::get<T>(m_states);
      FTC_LOG_INFO("Estado: " << typeid(*state).name() << std::endl); 
    };

    void setCurrentStateToNull();
    
    states::SupportedProtocols::SupportedProtocol protocol() const;
    void protocol(states::SupportedProtocols::SupportedProtocol value);

    FTCServer& server();
    
    void data_channel_info(DataChannelInfo_ptr info);
    DataChannelInfo_ptr data_channel_info() const;

    void data_channel(IDataChannel* channel);
    IDataChannel* data_channel() const;
    void read_only(bool value);
    bool read_only() const;

    bool close_data_channel(ChannelClosedReasons::ChannelClosedReason reason);

    const FTCServerConfig& config;

    void exception_raised(const std::string& msg);
    void exception_raised(const std::exception& e);

  private:
    typedef boost::mpl::vector40<
      states::v1_4::CloseState,
      states::v1_4::GetOperationState,
      states::v1_4::GetPositionState,
      states::v1_4::GetSizeState,
      states::v1_4::KeepAliveState,
      states::v1_4::OpenState,
      states::v1_4::ReadState,
      states::v1_4::SetPositionState,
      states::v1_4::SetSizeState,
      states::v1_4::ValidateKeyState,
      states::v1_4::VersionHandshakeState,
      states::v1_4::WriteState,
      states::v1_2::CloseState,
      states::v1_2::GetOperationState,
      states::v1_2::GetPositionState,
      states::v1_2::GetSizeState,
      states::v1_2::KeepAliveState,
      states::v1_2::OpenState,
      states::v1_2::ReadState,
      states::v1_2::SetPositionState,
      states::v1_2::SetSizeState,
      states::v1_2::ValidateKeyState,
      states::v1_2::WriteState,
      states::v1_1::CloseState,
      states::v1_1::GetOperationState,
      states::v1_1::GetPositionState,
      states::v1_1::GetSizeState,
      states::v1_1::OpenState,
      states::v1_1::ReadState,
      states::v1_1::SetPositionState,
      states::v1_1::SetSizeState,
      states::v1_1::ValidateKeyState,
      states::v1_1::WriteState,
      boost::mpl::void_,
      boost::mpl::void_,
      boost::mpl::void_,
      boost::mpl::void_,
      boost::mpl::void_,
      boost::mpl::void_,
      boost::mpl::void_> states_type;

    typedef boost::make_variant_over<states_type>::type variant_states_type;

    variant_states_type m_states;

    FTCServer& m_server;
    tecgraf::ftc::v1_04_01::states::State* state;
    Buffer m_buffer;
    states::SupportedProtocols::SupportedProtocol supported_protocol;

    DataChannelInfo_ptr m_info;
    IDataChannel* m_data_channel;
    bool m_read_only;
  };
}}}

#endif

