// -*- coding: iso-8859-1-unix -*-
#ifndef FTCSERVERCONFIG_V1_04_01_H_
#define FTCSERVERCONFIG_V1_04_01_H_

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
# pragma once
#endif

#include "ftc/ServerConfig.h"

namespace tecgraf { namespace ftc { namespace v1_04_01 {
  /**
  * @brief Classe que implementa as configuraes utilizadas no FTCServer.
  *
  * @author Tecgraf/PUC-Rio
  */
  class FTCServerConfig : public ServerConfig {
  public:

    /// @copydoc ServerConfig::ServerConfig()
    FTCServerConfig();
    /// @copydoc ServerConfig::~ServerConfig()
    virtual ~FTCServerConfig();

    /// @copydoc ServerConfig::hostname()
    virtual const std::string& hostname() const;
    /// @copydoc ServerConfig::hostname(const std::string&)
    virtual void hostname(const std::string& value);
    /// @copydoc ServerConfig::port()
    virtual uint16_t port() const;
    /// @copydoc ServerConfig::port(uint16_t)
    virtual void port(uint16_t value);
    /// @copydoc ServerConfig::channel_request_timeout()
    virtual uint32_t channel_request_timeout() const;
    /// @copydoc ServerConfig::channel_request_timeout(const uint32_t)
    virtual void channel_request_timeout(const uint32_t value);
    /// @copydoc ServerConfig::client_timeout()
    virtual uint32_t client_timeout() const;
    /// @copydoc ServerConfig::client_timeout(const uint32_t)
    virtual void client_timeout(const uint32_t value);
    /// @copydoc ServerConfig::max_clients()
    virtual std::size_t max_clients() const;
    /// @copydoc ServerConfig::max_clients(std::size_t)
    virtual void max_clients(std::size_t value);
    /// @copydoc ServerConfig::max_channel_requests()
    virtual std::size_t max_channel_requests() const;
    /// @copydoc ServerConfig::max_channel_requests(std::size_t)
    virtual void max_channel_requests(std::size_t value);
    /// @copydoc ServerConfig::client_buffer_size()
    virtual std::size_t client_buffer_size() const;
    /// @copydoc ServerConfig::client_buffer_size(std::size_t)
    virtual void client_buffer_size(std::size_t value);
    /// @copydoc ServerConfig::is_test_mode()
    virtual bool is_test_mode() const;
    /// @copydoc ServerConfig::is_test_mode(bool)
    virtual void is_test_mode(bool value);
    /// @copydoc ServerConfig::log_level()
    virtual ServerLogLevel log_level() const;
    /// @copydoc ServerConfig::log_level(ServerLogLevel)
    virtual void log_level(ServerLogLevel value);
    /// @copydoc ServerConfig::log_filename()
    virtual const std::string& log_filename() const;
    /// @copydoc ServerConfig::log_filename(const std::string&)
    virtual void log_filename(const std::string& value);
    /// @copydoc ServerConfig::log_date_time()
    virtual bool log_date_time() const;
    /// @copydoc ServerConfig::log_date_time(bool)
    virtual void log_date_time(bool value);
    /// @copydoc ServerConfig::thread_pool_size()
    virtual std::size_t thread_pool_size() const;
    /// @copydoc ServerConfig::thread_pool_size(const std::size_t)
    virtual void thread_pool_size(const std::size_t value);

    /**
    * @brief Retorna o tamanho dos pedaos em bytes utilizados para transmitir um canal de dados para o cliente.
    * @return O tamanho dos pedaos em bytes utilizados para transmitir um canal de dados para o cliente.
    */
    virtual std::size_t chunk_size() const;

    /**
    * @brief Define o tamanho dos pedaos em bytes utilizados para transmitir um canal de dados para o cliente.
    * @param value O tamanho dos pedaos em bytes utilizados para transmitir um canal de dados para o cliente.
    */
    virtual void chunk_size(std::size_t value);

    /// @copydoc ServerConfig::print(std::ostream&)
    virtual void print(std::ostream& out) const;
  private:
    uint16_t m_port;
    std::string m_hostname;
    uint32_t m_channel_request_timeout ;
    uint32_t m_client_timeout;
    std::size_t m_max_clients;
    std::size_t m_max_channel_requests;
    std::size_t m_client_buffer_size;
    std::size_t m_chunk_size;
    bool m_test_mode;
    ServerLogLevel m_log_level;
    std::string m_log_filename;
    bool m_log_date_time;
    std::size_t m_thread_pool_size;
  };
}}}

#endif

