// -*- coding: iso-8859-1-unix -*-
#ifndef FTCSERVER_V1_04_01_H_
#define FTCSERVER_V1_04_01_H_

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
# pragma once
#endif

#include "ftc/BaseServer.h"
#include "ftc/AccessKey.h"
#include "ftc/DataChannelProvider.h"
#include "ftc/DataChannelInfo.h"
#include "ftc/DefaultServerExceptionHandler.h"
#include "ftc/FTCServerConfig.h"

#include <map>
#include <string>

#include <boost/asio/system_timer.hpp>
#include <boost/thread.hpp>

namespace tecgraf { namespace ftc { namespace v1_04_01 {

  class Connection;

  /**
  * @brief Classe que representa um servidor de arquivos
  *
  * @author Tecgraf/Puc-Rio
  */
  class FTCServer : public BaseServer
  {
  public:
    /**
    * @copydoc BaseServer::BaseServer()
    *
    * @param provider Objeto que ira prover os arquivos que sero servidos
    */
    FTCServer(DataChannelProvider& provider, const FTCServerConfig& config);

    /**
    * @brief Destrutor
    */
    virtual ~FTCServer ();

    /// @copydoc BaseServer::config()
    const FTCServerConfig& config() const;

    /**
    * @brief Cria uma descrio do canal que ser consumido por um cliente.
    *
    * @param requester Objeto responsavel pela requisio
    * @param data_id Identificador do canal de dados
    * @param access_key Chave de acesso. Se nula, uma ser criada automaticamente.
    * @param use_transfer_to Informa a possibilidade de utilizao do mtodo TransferTo caso o canal suporte.
    * @param wait_ready_timeout_ms Tempo mximo para esperar o servidor comear a aceitar conexes.
    *
    * @return A descrio de uma requisio de um canal para ser consumido.
    */
    DataChannelInfo_ptr register_data_channel_info(void * requester, const std::string& data_id, const AccessKey * const access_key = 0, bool use_transfer_to = true, uint32_t wait_ready_timeout_ms = 60000);

    /**
    * @brief Consome a descrio de uma requisio de canal retornando o mesmo.
    *
    * @param access_key Chave de acesso que identifica o canal
    *
    * @return A descrio de uma requisio de um canal para ser consumido.
    *
    */
    DataChannelInfo_ptr consume_data_channel_info(AccessKey * access_key);

    /**
    * @brief Mtodo que retorna o objeto provedor de arquivos utilizado pelo servidor
    *
    * @return Objeto provedor de arquivos
    */
    DataChannelProvider& provider() const;

  protected:
    /// @copydoc BaseServer::create_session(Connection&)
    virtual BaseSession * create_session(Connection& conn);

    /**
    * @brief Verifica se ocorreu timeout em algum descritor de requisio de canal (DataChannelInfo)
    * @param timeout_ms Tempo mximo em milisegundos para remover o canal
    */
    virtual void check_timeout(const uint64_t& timeout_ms);
  private:
    FTCServerConfig m_config;
    DataChannelProvider& m_provider;

    boost::mutex m_mutex;
    typedef std::map<const AccessKey*, DataChannelInfo_ptr, key_less_comp> AccessKey2DataChannelInfoMap;
    AccessKey2DataChannelInfoMap m_channelMap;

    DefaultServerExceptionHandler m_exception_handler;
  };
}}}

#endif

