// -*- coding: iso-8859-1-unix -*-
#ifndef ERRORCODES_V1_04_01_H_
#define ERRORCODES_V1_04_01_H_

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
# pragma once
#endif

namespace tecgraf { namespace ftc { namespace v1_04_01
{
  namespace ErrorCodes {

    /**
    * @brief Descreve o erros do protocolo.
    */
    enum ErrorCode
    {
      ok = 0 ///< Indica que uma operao foi realizada com sucesso (v1.1+).
      , failure = -1 ///< Indica que uma operao falhou (v1.1+).
      , invalid_key = -2 ///< Indica que uma chave invlida foi utilizada (v1.1+).
      , file_not_found = -3 ///< Indica que um arquivo solicitado no existe (v1.1+).
      , no_permission = -4 ///< Indica falta de permisso para a realizao de uma operao (v1.1+).
      , file_locked = -5 ///< Indica que no  possvel escrever num arquivo porque o arquivo possui um <i>lock</i> associado (v1.1+).
      , max_clients_reached = -6 ///< Indica que o numero maximo de clientes no servidor foi atingido (v1.1+).
      , file_not_open = -7 ///< Indica que o arquivo no esta aberto (v1.2+).
      , read_only = -8 ///< Indica que no  possvel escrever num arquivo porque este esta aberto somente para leitura (v1.2+).
      , invalid_version = -9 ///< Indica que a verso do protocolo utilizada pelo cliente nao  suportada pelo servidor (v1.2+).
      , end_of_file = -10 ///< Indica final de arquivo (v1.2+).
      , unsupported_operation = -11 ///< Indica operao nao suportada (v1.4+).
      , unknown_error = -12 ///< Indica erro desconhecido (v1.4+).
      , invalid_protocol_message = -13 ///< Indica erro de mensagem invlida no handshake de verso (v1.4+).
    };

  }

}}}

#endif

