// -*- coding: iso-8859-1-unix -*-
#ifndef DEFAULTSERVEREXCEPTIONHANDLER_V1_04_01_H_
#define DEFAULTSERVEREXCEPTIONHANDLER_V1_04_01_H_

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
# pragma once
#endif

#include "ftc/ServerExceptionHandler.h"

#include <string>
#include <stdexcept>

namespace tecgraf { namespace ftc { namespace v1_04_01 {

  /**
  * @copydoc tecgraf::ftc::v1_04_01::ServerExceptionHandler
  *
  * Implementao padro que faz o log das excees lanadas pelo servidor
  */
  class DefaultServerExceptionHandler : public ServerExceptionHandler {
  public:
    /// @copydoc ServerExceptionHandler::ServerExceptionHandler()
    DefaultServerExceptionHandler();

    /// @copydoc ServerExceptionHandler::~ServerExceptionHandler()
    virtual ~DefaultServerExceptionHandler();

    /// @copydoc ServerExceptionHandler::exception_raised(const std::string&)
    virtual void exception_raised(const std::string& msg);

    /// @copydoc ServerExceptionHandler::exception_raised(const std::string&, const std::string&)
    virtual void exception_raised(const std::string& msg, const std::string& data_id);

    /// @copydoc ServerExceptionHandler::exception_raised(const std::exception&)
    virtual void exception_raised(const std::exception& e);

    /// @copydoc ServerExceptionHandler::exception_raised(const std::exception&, const std::string&)
    virtual void exception_raised(const std::exception& e, const std::string& data_id);
  };

}}}

#endif

