// -*- coding: iso-8859-1-unix -*-
#ifndef DEFAULTDATAPROVIDER_V1_04_01_H_
#define DEFAULTDATAPROVIDER_V1_04_01_H_

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
# pragma once
#endif

#include "ftc/DataChannelProvider.h"

namespace tecgraf { namespace ftc { namespace v1_04_01 {

  /**
  * @brief Classe responsvel por fornecer os arquivos requisitados.
  *
  * Implementao padro de um DataChannelProvider que utiliza FileChannel como canal de dados. Onde o data_id neste caso  utilizado como o caminho para o arquivo.
  *
  * @author Tecgraf/PUC-Rio
  */
  class DefaultDataProvider : public DataChannelProvider {
  public:
    DefaultDataProvider();
    virtual ~DefaultDataProvider();

    /// @copydoc DataChannelProvider::create_data_channel
    virtual IDataChannel* create_data_channel(void * requester, const std::string& data_id, bool read_only);

    /// @copydoc DataChannelProvider::data_channel_closed
    virtual void data_channel_closed(void * requester, const std::string& data_id, ChannelClosedReasons::ChannelClosedReason reason);

    /// @copydoc DataChannelProvider::is_locked
    virtual bool is_locked(void * requester, std::string const& data_id);
  };

} } }

#endif

