// -*- coding: iso-8859-1-unix -*-
#ifndef DATACHANNELPROVIDER_V1_04_01_H_
#define DATACHANNELPROVIDER_V1_04_01_H_

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
# pragma once
#endif

#include <string>

#include "ftc/IDataChannel.h"
#include "ftc/ChannelClosedReason.h"

namespace tecgraf { namespace ftc { namespace v1_04_01 {

  /**
  * @brief Classe responsvel por fornecer os canais requisitados.
  *
  *  possvel, por exemplo, ter um provider que cria canais de dados de arquivos fsicos no disco. Ou ento, canais de dados de uma fonte de dados com gerao
  * de dados constantes (streaming).
  *
  * @author Tecgraf/PUC-Rio
  */
  class DataChannelProvider {
  public:

    /**
    * @brief Destrutor
    */
    virtual ~DataChannelProvider() {}

    /**
    * @brief Cria um canal para um arquivo.
    *
    * @param requester O responsvel pela requisio do canal.
    * @param data_id O identificador do canal de dados.
    * @param read_only Indica se o canal ser somente para leitura ou no.
    *
    * @return O canal de dados, ou <c>null</c>, caso o arquivo no exista.
    *
    */
    virtual IDataChannel* create_data_channel(void * requester, const std::string& data_id, bool read_only) = 0;

    /**
    * @brief Indica que um canal foi fechado.
    *
    * @param requester O responsvel pela requisio do canal.
    * @param data_id O identificador do canal de dados.
    * @param reason O motivo que o canal foi fechado;
    */
    virtual void data_channel_closed(void * requester, const std::string& data_id, ChannelClosedReasons::ChannelClosedReason reason) = 0;

    /**
    * @brief Verifica se o canal de dados possui um <i>lock</i> que impede a escrita.
    *
    * @param requester O responsvel pela requisio do canal.
    * @param data_id O identificador do canal de dados.
    *
    * @return {@code true} caso exista um <i>lock</i> associado ao arquivo, ou
    *         {@code false}, caso contrrio.
    */
    virtual bool is_locked(void * requester, std::string const& data_id) = 0;

  };

} } }

#endif

