// -*- coding: iso-8859-1-unix -*-
#ifndef CONNECTION_V1_04_01_H_
#define CONNECTION_V1_04_01_H_

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
# pragma once
#endif

#include <boost/asio.hpp>
#include <boost/array.hpp>
#include <boost/noncopyable.hpp>
#include <boost/shared_ptr.hpp>
#include <boost/enable_shared_from_this.hpp>
#include <boost/asio/system_timer.hpp>
#include <boost/detail/atomic_count.hpp>

namespace tecgraf { namespace ftc { namespace v1_04_01 {  
  
  class BaseServer;
  class BaseSession;

  class Connection
    : public boost::enable_shared_from_this<Connection>,
      private boost::noncopyable
  {
  public:
    enum CloseStatus {
      none,
      requested_by_state,
      client_timeout,
      socket_error,
      server_shuting_down
    };

    explicit Connection(boost::asio::io_service& io_service, BaseServer& server, boost::shared_ptr<boost::detail::atomic_count> num_connections);
    ~Connection();

    void start();

    boost::asio::ip::tcp::socket& socket();

    void stop(CloseStatus status);
    CloseStatus close_status() const;
  private:
    bool stopped() const;

    void start_timeout_timer();
    void start_operations();

    /// Handle completion of a client timeout
    void handle_timeout(const boost::system::error_code& ec);

    /// Handle completion of a read operation.
    void handle_read(const boost::system::error_code& ec);

    /// Handle completion of a write operation.
    void handle_write(const boost::system::error_code& ec);

    BaseServer& server;

    /// Socket for the connection.
    boost::asio::ip::tcp::socket m_socket;

    boost::asio::system_timer timeout_timer;
    bool read_in_progress;
    bool write_in_progress;
    boost::shared_ptr<boost::detail::atomic_count> num_connections;
    BaseSession* session;
    CloseStatus m_close_status;
  };

  typedef boost::shared_ptr<Connection> Connection_ptr;

}}}

#endif

