// -*- coding: iso-8859-1-unix -*-
#ifndef BASESESSION_V1_04_01_H_
#define BASESESSION_V1_04_01_H_

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
# pragma once
#endif

#include <boost/asio.hpp>
#include <boost/chrono.hpp>

namespace tecgraf { namespace ftc { namespace v1_04_01 {  

  namespace states { class State; }

  class BaseServer;
  class ServerConfig;
  class Connection;

  class BaseSession
  {
  public:
    BaseSession(BaseServer& server, const ServerConfig& config, Connection& conn);
    virtual ~BaseSession();

    virtual bool want_read() const = 0;
    virtual bool do_read(boost::system::error_code& ec) = 0;
    virtual bool want_write() const = 0;
    virtual bool do_write(boost::system::error_code& ec) = 0;

    bool max_clients_reached() const;
    void max_clients_reached(bool max_clients_reached);

    BaseServer& server();
    Connection& connection();
    const ServerConfig& config;

    bool check_timeout(const uint64_t& timeout_ms) const;
    /// @brief Mtodo que realiza a marcao do momento da ltima atividade.      
    void mark_last_activity();
  private:
    BaseServer& m_server;
    Connection& m_connection;

    boost::chrono::system_clock::time_point m_last_activity;
    bool m_max_clients_reached;
  };

}}}

#endif

