#ifndef PROJECTITEMDATAVIEWIMPL_V1_02_H_
#define PROJECTITEMDATAVIEWIMPL_V1_02_H_

#include "stubs/project.h"

namespace tecgraf
{
    namespace openbus
    {
        namespace data_service
        {
            namespace project
            {
                namespace v1_02
                {
                    /** 
                     * @brief Classe que implementa o ProjectItemDataView valutype.
                     */
                    class ProjectItemDataViewImpl : 
                        public virtual OBV_tecgraf::openbus::data_service::project::v1_02::ProjectItemDataView,
                        public virtual CORBA::DefaultValueRefCountBase
                    {
                        public:
                            ProjectItemDataViewImpl();
                            virtual ~ProjectItemDataViewImpl();

                            ProjectItemDataViewImpl(
                                const tecgraf::openbus::data_service::core::v1_02::DataKey&  _itfld_fKey,
                                const char* _itfld_fOwner,
                                const char* _itfld_fDescription,
                                const char* _itfld_fPath,
                                const char* _itfld_fType,
                                CORBA::LongLong _itfld_fSize,
                                CORBA::Boolean _itfld_fIsContainer,
                                CORBA::Boolean _itfld_fCanRead,
                                CORBA::Boolean _itfld_fCanWrite,
                                tecgraf::openbus::data_service::core::v1_02::TimeStamp _itfld_fCreationDate,
                                tecgraf::openbus::data_service::core::v1_02::TimeStamp _itfld_fModificationDate
                            );
                            virtual tecgraf::openbus::data_service::core::v1_02::DataKey * getKey();
                            virtual char * getInterfaceName();

                            virtual CORBA::ValueBase* _copy_value();

                    };
                    
                    /** 
                     * @brief Classe responsável por construir instancias de ProjectItemDataView. 
                     */
                    class ProjectItemDataViewFactory :  public virtual CORBA::ValueFactoryBase
                    {
                      public:
                        virtual ~ProjectItemDataViewFactory();
                        virtual CORBA::ValueBase*  create_for_unmarshal();
                    };
                }
            }
        }
    }
}

#endif // PROJECTITEMDATAVIEWIMPL_V1_01_H_
