#ifndef PROJECTDATAVIEWIMPL_V1_02_H_
#define PROJECTDATAVIEWIMPL_V1_02_H_

#include "stubs/project.h"

namespace tecgraf
{
    namespace openbus
    {
        namespace data_service
        {
            namespace project
            {
                namespace v1_02
                {
                    /** 
                     * @brief Classe que implementa o ProjectDataView valuetype.
                     */
                    class ProjectDataViewImpl : 
                        public virtual OBV_tecgraf::openbus::data_service::project::v1_02::ProjectDataView,
                        public virtual CORBA::DefaultValueRefCountBase
                    {
                        public:
                            ProjectDataViewImpl();
                            virtual ~ProjectDataViewImpl();

                            ProjectDataViewImpl(
                                const tecgraf::openbus::data_service::core::v1_02::DataKey&  _itfld_fKey,
                                const char* _itfld_fOwner,
                                const char* _itfld_fDescription,
                                const char* _itfld_fPath,
                                const char* _itfld_fSoftware,
                                CORBA::LongLong _itfld_fSize,
                                const tecgraf::openbus::data_service::project::v1_02::StringSeq&  _itfld_fReadingUsers,
                                const tecgraf::openbus::data_service::project::v1_02::StringSeq&  _itfld_fWritingUsers,
                                tecgraf::openbus::data_service::core::v1_02::TimeStamp _itfld_fCreationDate,
                                tecgraf::openbus::data_service::core::v1_02::TimeStamp _itfld_fModificationDate
                            );
                            virtual tecgraf::openbus::data_service::core::v1_02::DataKey * getKey();
                            virtual char * getInterfaceName();

                            virtual CORBA::ValueBase* _copy_value();

                    };
                    
                    /** 
                     * @brief Classe responsável por construir instancias de ProjectDataView. 
                     */
                    class ProjectDataViewFactory :  public virtual CORBA::ValueFactoryBase
                    {
                      public:
                        virtual ~ProjectDataViewFactory();
                        virtual CORBA::ValueBase*  create_for_unmarshal();
                    };
                }
            }
        }
    }
}

#endif // PROJECTDATAVIEWIMPL_V1_01_H_

