#ifndef UNSTRUCTUREDDATA_V1_02_H_
#define UNSTRUCTUREDDATA_V1_02_H_

#include "stubs/data_service.h"

namespace tecgraf { namespace openbus { namespace data_service { namespace core {
namespace v1_02 {

/** 
 * @brief Implementação 
 */
class UnstructuredDataViewImpl
  : public virtual OBV_tecgraf::openbus::data_service::core::v1_02::UnstructuredDataView
  , public virtual CORBA::DefaultValueRefCountBase
{
public:
  UnstructuredDataViewImpl();
  virtual ~UnstructuredDataViewImpl();

  UnstructuredDataViewImpl(
                           const tecgraf::openbus::data_service::core::v1_02::DataKey&  _itfld_fKey,
                           const char* _itfld_fHost,
                           CORBA::ULong _itfld_fPort,
                           const tecgraf::openbus::data_service::core::v1_02::OctetSeq&  _itfld_fAccessKey,
                           CORBA::Boolean _itfld_fWritable
                           );
  virtual tecgraf::openbus::data_service::core::v1_02::DataKey * getKey();
  virtual char * getInterfaceName();

  virtual CORBA::ValueBase* _copy_value();
};

/** 
 * @brief Classe responsável por construir instancias de UnstructuredData. 
 */
class UnstructuredDataViewFactory :  public virtual CORBA::ValueFactoryBase
{
public:
  virtual ~UnstructuredDataViewFactory();
  virtual CORBA::ValueBase*  create_for_unmarshal();
};

} } } } }

#endif  // UNSTRUCTUREDDATA_V1_02_H_
