#ifndef DATAKEYWRAPPER_V1_02_H
#define DATAKEYWRAPPER_V1_02_H

#include <string>

#include "stubs/data_service.h"

namespace tecgraf { namespace openbus { namespace data_service { namespace core {
namespace v1_02 {

/** 
 * @brief Classe responsável por gerenciar as chaves.
 */
class DataKeyWrapper
{
public: 
  DataKeyWrapper() {}
  DataKeyWrapper(DataKey const& key); 
  DataKeyWrapper(std::string const & system_deployment_id
                 , std::string const& datasource_id
                 , std::string const& data_id);
  ~DataKeyWrapper();

  DataKey dataKey();
  std::string dataId() const
  {
    return data_id;
  }
  std::string dataSourceId() const
  {
    return datasource_id;
  }
  std::string systemDeploymentId() const
  {
    return system_deployment_id;
  }
  void systemDeploymentId(std::string const& v)
  {
    system_deployment_id = v;
  }
  void dataId(std::string const& v)
  {
    data_id = v;
  }
  void dataSourceId(std::string const& v)
  {
    datasource_id = v;
  }
  bool verifyKey(DataKey const& key);

private: 
  std::string system_deployment_id, datasource_id, data_id;
}; 

} } } } }

#endif // DATAKEYWRAPPER_v1_01_H
