#ifndef CONFIG_H
#define CONFIG_H

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
# pragma once
#endif

#include <ftc/FTCServerConfig.h>
#include <boost/cstdint.hpp>

class Config : public tecgraf::ftc::v1_04_01::FTCServerConfig
{
public:
  Config();

  int parse(int argc, char *argv[], std::ostream& out);
  const std::vector<std::string>& files() const;

  virtual const std::string& hostname() const;
  virtual void hostname(const std::string& value);
  virtual uint16_t port() const;
  virtual void port(uint16_t value);
  virtual uint32_t channel_request_timeout() const;
  virtual void channel_request_timeout(const uint32_t value);
  virtual uint32_t client_timeout() const;
  virtual void client_timeout(const uint32_t value);
  virtual std::size_t max_clients() const;
  virtual void max_clients(std::size_t value);
  virtual std::size_t max_channel_requests() const;
  virtual void max_channel_requests(std::size_t value);
  virtual std::size_t client_buffer_size() const;
  virtual void client_buffer_size(std::size_t value);
  virtual bool is_test_mode() const;
  virtual void is_test_mode(bool value);
  virtual ServerLogLevel log_level() const;
  virtual void log_level(ServerLogLevel loglevel);
  virtual const std::string& log_filename() const;
  virtual void log_filename(const std::string& value);
  virtual bool log_date_time() const;
  virtual void log_date_time(bool value);
  virtual std::size_t thread_pool_size() const;
  virtual void thread_pool_size(const std::size_t value);
  virtual std::size_t chunk_size() const;
  virtual void chunk_size(std::size_t value);
private:
  uint16_t m_port;
  std::string m_hostname;
  uint32_t m_select_timeout;
  uint32_t m_channel_request_timeout;
  uint32_t m_client_timeout;
  std::size_t m_max_clients;
  std::size_t m_max_channel_requests;
  std::size_t m_client_buffer_size;
  bool m_test_mode;
  ServerLogLevel m_log_level;
  std::string m_log_filename;
  bool m_log_date_time;
  std::size_t m_thread_pool_size;
  std::size_t m_chunk_size;
  std::vector<std::string> m_files;
};

#endif
