#ifndef HIERARCHICALNAVIGATIONIMPL_V1_02_H_
#define HIERARCHICALNAVIGATIONIMPL_V1_02_H_

#include <scs/ComponentContext.h>
#include "DataServerContext.h"

#include <stubs/hierarchical_data_service.h>
#include <stubs/project.h>

namespace tecgraf { namespace openbus { namespace data_service { namespace core {
namespace v1_02 { namespace demo { namespace file_system {

/** 
 * @brief Implementação do serviço de dados 
 */
class ProjectNavigationImpl
  : virtual public POA_tecgraf::openbus::data_service::project::v1_02::IProjectNavigationDataService
{
public:
  /** 
   * @brief 
   * 
   * @param componentContext
   * 
   * @return 
   */
  ~ProjectNavigationImpl( );

  DataDescriptionSeq* getRoots() ;
  DataDescriptionSeq* getChildren( const DataKey &  key );
  DataDescription* getParent( const DataKey &  key );

  typedef data_service::project::v1_02::ProjectDataViewSeq ProjectDataViewSeq;
  ProjectDataViewSeq* getProject( const char* fOwner );

  /** 
   * @brief 
   * 
   * @param componentContext
   */
  ProjectNavigationImpl( scs::core::ComponentContext * componentContext );

private:
  DataServerContext * componentContext;

  // Prevent copying and assigment of servants
  ProjectNavigationImpl(ProjectNavigationImpl const& obj);
  ProjectNavigationImpl& operator=(ProjectNavigationImpl const& obj);
};

} } } } } } }

#endif  // HIERARCHICALNAVIGATIONIMPL_V1_02_H_
