#include <libgen.h>

#include "ProjectNavigationImpl.h"
#include "DataServerContext.h"
#include "DataServiceImpl.h"
#include "FileSystemUtils.h"
#include "ProjectDataViewImpl.h"

namespace tecgraf { namespace openbus { namespace data_service { namespace core {
namespace v1_02 { namespace demo { namespace file_system {

ProjectNavigationImpl::ProjectNavigationImpl( scs::core::ComponentContext * componentContext )
{
  std::cout << "ProjectNavigationImpl this: " << this << std::endl;
    this->componentContext = static_cast<DataServerContext*>(componentContext);
}

ProjectNavigationImpl::~ProjectNavigationImpl()
{
  std::cout << "~ProjectNavigationImpl this: " << this << std::endl;
}

DataDescriptionSeq * ProjectNavigationImpl::getRoots() 
{
    std::cout << "[getRoots BEGIN]" << std::endl;
    std::vector<std::string> dirList;
   
    std::string rootPath( componentContext->getRootPath()); 
    std::cout << "   getDirList: " << rootPath << std::endl;
    dirList.push_back(rootPath);
    
    DataDescriptionSeq * dataList = new DataDescriptionSeq(dirList.size());
    dataList->length(dirList.size());
    
    DataServiceImpl * dataService = componentContext->IDataService();

    DataDescription_var desc;
    for (unsigned int i = 0 ; i < dirList.size() ; i++ )
    {
        std::cout << "Root: " << dirList[i] << std::endl;
        desc = dataService->createDataDescription(dirList[i]);
        (*dataList)[i] = desc;
    }

    std::cout << "[getRoots END]" << std::endl;
    return dataList;
}

DataDescriptionSeq * ProjectNavigationImpl::getChildren( const DataKey &  key ) 
{
    std::cout << "[getChildren BEGIN]" << std::endl;
    
    if(!componentContext->verifyPermission( key ))
        throw DataAccessDenied();

    DataKeyWrapper keyWrapper = DataKeyWrapper(key);
    std::string path = keyWrapper.dataId();

    if (!isDir(path))
    {
      throw ServiceFailure(); // "parentKey não é um diretório."
    }
    
    std::vector<std::string> dirList;
    getDirList(path , dirList); 
    
    DataDescriptionSeq * dataList = new DataDescriptionSeq(dirList.size());
    dataList->length(dirList.size());

    DataServiceImpl * dataService = componentContext->IDataService();
    DataDescription_var desc;
    for (unsigned int i =0 ; i < dirList.size() ; i++ )
    {
        std::cout << "Children: " << dirList[i] << std::endl;
        desc = dataService->createDataDescription( dirList[i] );
        (*dataList)[i] = desc;
    }

    std::cout << "[getChildren END]" << std::endl;
    return dataList;
}

DataDescription * ProjectNavigationImpl::getParent( const DataKey &  key )
{
    std::cout << "[getParent BEGIN]" << std::endl;
    if(!componentContext->verifyPermission( key ))
        throw DataAccessDenied();

    DataKeyWrapper keyWrapper(key);
    std::string path = keyWrapper.dataId();
    char * file    = strdup(path.c_str());
    char * dirpath = dirname(file);

    std::string parentDir(dirpath);

    if( (dirpath != NULL) && (! isDir(parentDir) ))
    {
        free(file);
        throw ServiceFailure();//"Erro ao ler o diretório pai."
    }

    free(file);
    DataServiceImpl * dataService = componentContext->IDataService();
    DataDescription * desc = dataService->createDataDescription(parentDir);
    std::cout << "[getParent END]" << std::endl;
    return desc; 
}

ProjectNavigationImpl::ProjectDataViewSeq*
ProjectNavigationImpl::getProject( const char* fOwner )
{
  std::cout << "ProjectNavigationImpl::getProject" << std::endl;
  std::string rootPath( componentContext->getRootPath()); 

  std::vector<std::string> dirList;
  getDirList(rootPath, dirList); 

  std::cout << "paths ";
  std::copy(dirList.begin(), dirList.end(), std::ostream_iterator<std::string>
            (std::cout, " "));
  std::cout << std::endl;

  namespace project = data_service::project::v1_02;

  project::ProjectDataViewSeq_var seq(new project::ProjectDataViewSeq);
  seq->length(dirList.size());
  std::size_t i = 0;
  DataServiceImpl * dataService = componentContext->IDataService();
  for(std::vector<std::string>::const_iterator first = dirList.begin()
        , last = dirList.end();first != last;++first,++i)
  {
    data_service::project::v1_02::StringSeq users;
    users.length(1);
    users[0] = "User";
    DataDescription* description
      (dataService->createDataDescription(*first));
    DataKey_var key (new DataKey(description->fKey));
    seq[i] = new tecgraf::openbus::data_service::project::v1_02::ProjectDataViewImpl
      (key.in(), "owner", "description", "path"
       , "software", 0u, users, users, 0, 0);
  }
  return seq._retn();
}

} } } } } } }

