#ifndef ILOGFILEVIEW_V1_01_H_
#define ILOGFILEVIEW_V1_01_H_

#include "DataKeyWrapper.h"

#include "stubs/file_system.h"

namespace tecgraf { namespace openbus { namespace data_service { namespace core {
namespace v1_02 {

namespace demo { namespace file_system {

class DataServerContext;

/** 
 * @brief Implementação da interface ILogFileView 
 */
class LogFileValueTypeDataViewImpl
  : virtual public OBV_tecgraf::openbus::data_service::core::v1_02::demo::file_system::LogFileValueTypeDataView
  , public virtual CORBA::DefaultValueRefCountBase
{
public:
  LogFileValueTypeDataViewImpl();
  LogFileValueTypeDataViewImpl(DataServerContext * context, DataKey key
                               , file_system::ILogFile_var log_file);
  virtual ~LogFileValueTypeDataViewImpl();
  
  tecgraf::openbus::data_service::core::v1_02::DataKey * getKey() { return &(fKey()); }
  char * getInterfaceName() { return (char*)_tc_LogFileValueTypeDataView->id(); }
  // tecgraf::openbus::data_service::core::v1_02::demo::file_system::ILogFile_ptr logFile();

  CORBA::ValueBase* _copy_value();
private:
  DataServerContext * componentContext;
  // file_system::ILogFile_var log_file;
};

/** 
 * @brief Classe responsável por construir instancias de FileDataView. 
 */
class LogFileValueTypeDataViewFactory :  public virtual CORBA::ValueFactoryBase
{
public:
  virtual ~LogFileValueTypeDataViewFactory();
  virtual CORBA::ValueBase* create_for_unmarshal()
  {
    std::cout << "LogFileValueTypeDataViewFactory::create_for_unmarshal()" << std::endl;
    return new LogFileValueTypeDataViewImpl;
  }
};

class ILogFileImpl : virtual public POA_tecgraf::openbus::data_service::core::v1_02::demo::file_system::ILogFile
{
public:

  virtual ~ILogFileImpl();

  virtual char* getLastLine() ;
  virtual void deactivate() ;

};

} } } } } } }

#endif
