#include <iostream>

#include <DataKeyWrapper.h>

#include "DataServerContext.h"
#include "ILogFileViewImpl.h"

namespace tecgraf { namespace openbus { namespace data_service { namespace core {
namespace v1_02 { namespace demo { namespace file_system {

LogFileValueTypeDataViewImpl::LogFileValueTypeDataViewImpl()
{
  std::cout << "LogFileValueTypeDataViewImpl::LogFileValueTypeDataViewImpl default " << this << std::endl;
}

LogFileValueTypeDataViewImpl::~LogFileValueTypeDataViewImpl()
{
  std::cout << "LogFileValueTypeDataViewImpl::~LogFileValueTypeDataViewImpl " << this << std::endl;
}

LogFileValueTypeDataViewFactory::~LogFileValueTypeDataViewFactory()
{
}

LogFileValueTypeDataViewImpl::LogFileValueTypeDataViewImpl(DataServerContext * context,DataKey key
                                                           , file_system::ILogFile_var log_file)
  : componentContext(context)
{
  fKey(key);
  logFile(log_file);
  std::cout << "LogFileValueTypeDataViewImpl::LogFileValueTypeDataViewImpl " << this << std::endl;
}

CORBA::ValueBase* LogFileValueTypeDataViewImpl::_copy_value()
{
  std::cout << "LogFileValueTypeDataViewImpl::_copy_value " << this << std::endl;
  return new LogFileValueTypeDataViewImpl(componentContext, fKey(), logFile());
}

// tecgraf::openbus::data_service::core::v1_02::demo::file_system::ILogFile_ptr LogFileValueTypeDataViewImpl::logFile()
// {
//   return log_file.out();
// }

ILogFileImpl::~ILogFileImpl()
{
}

char* ILogFileImpl::getLastLine()
{
    std::cout << "[getLastLine BEGIN]" << std::endl;
    //TODO Ler a ultima linha do arquivo
    std::cout << "[getLastLine END]" << std::endl;
    return CORBA::string_dup("--ultima linha do arquivo.");
}

void ILogFileImpl::deactivate() 
{
    std::cout << "[deactivate BEGIN]" << std::endl;
    // PortableServer::POA * poa = componentContext->getPOA();
    // PortableServer::ObjectId_var objId = poa->servant_to_id(this);
    // poa->deactivate_object(objId);
    std::cout << "[deactivate END]" << std::endl;
}

} } } } } } }
