#ifndef HIERARCHICALTRANSFERIMPL_V1_02_H_
#define HIERARCHICALTRANSFERIMPL_V1_02_H_

#include <scs/ComponentContext.h>
#include "DataServerContext.h"

#include <stubs/hierarchical_data_service.h>

namespace tecgraf { namespace openbus { namespace data_service { namespace core {
namespace v1_02 { namespace demo { namespace file_system {

/** 
 * @brief Implementação do serviço de dados 
 */
class HierarchicalTransferImpl
  : virtual public POA_tecgraf::openbus::data_service::hierarchical::v1_02::IHierarchicalTransferDataService
{
public:

  virtual ~HierarchicalTransferImpl( );

  virtual DataKey* copyDataFrom( const DataKey &  parentKey, const DataKey &  sourceKey )
    throw( CORBA::SystemException , 
           ServiceFailure         , 
           InvalidDataKey         , 
           AbsentViews            , 
           UnavailableDataService ,
           DataAlreadyExist       ,
           DataNotFound           , 
           hierarchical::v1_02::UnsupportedOperation   , 
           DataAccessDenied       );

  virtual void updateDataFrom( const DataKey &  key, const DataKey &  sourceKey )
    throw( CORBA::SystemException , 
           ServiceFailure         , 
           DataAccessDenied       ,
           InvalidDataKey         , 
           DataNotFound           , 
           UnavailableDataService ,
           AbsentViews            ); 

  /** 
   * @brief 
   * 
   * @param componentContext
   */
  HierarchicalTransferImpl( scs::core::ComponentContext * componentContext );
private:
  DataServerContext* componentContext;

  // Prevent copying and assigment of servants
  HierarchicalTransferImpl(HierarchicalTransferImpl const& obj);
  HierarchicalTransferImpl& operator=(HierarchicalTransferImpl const& obj);
};

} } } } } } }

#endif // HIERARCHICALTRANSFERIMPL_V1_02_H_
