#ifndef HIERARCHICALNAVIGATIONIMPL_V1_02_H_
#define HIERARCHICALNAVIGATIONIMPL_V1_02_H_

#include <scs/ComponentContext.h>
#include "DataServerContext.h"

#include <stubs/hierarchical_data_service.h>

namespace tecgraf { namespace openbus { namespace data_service { namespace core {
namespace v1_02 { namespace demo { namespace file_system {

/** 
 * @brief Implementação do serviço de dados 
 */
class HierarchicalNavigationImpl
  : virtual public POA_tecgraf::openbus::data_service::hierarchical::v1_02::IHierarchicalNavigationDataService
{
public:
  /** 
   * @brief 
   * 
   * @param componentContext
   * 
   * @return 
   */
  virtual ~HierarchicalNavigationImpl( );

  virtual DataDescriptionSeq * getRoots() ;
  virtual DataDescriptionSeq * getChildren( const DataKey &  key );
  virtual DataDescription * getParent( const DataKey &  key );

  /** 
   * @brief 
   * 
   * @param componentContext
   */
  HierarchicalNavigationImpl( scs::core::ComponentContext * componentContext );

private:
  DataServerContext * componentContext;

  // Prevent copying and assigment of servants
  HierarchicalNavigationImpl(HierarchicalNavigationImpl const& obj);
  HierarchicalNavigationImpl& operator=(HierarchicalNavigationImpl const& obj);
};

} } } } } } }

#endif  // HIERARCHICALNAVIGATIONIMPL_V1_02_H_
