#include <libgen.h>

#include "HierarchicalNavigationImpl.h"
#include "DataServerContext.h"
#include "DataServiceImpl.h"
#include "FileSystemUtils.h"

namespace tecgraf { namespace openbus { namespace data_service { namespace core {
namespace v1_02 { namespace demo { namespace file_system {

HierarchicalNavigationImpl::HierarchicalNavigationImpl( scs::core::ComponentContext * componentContext )
{
  std::cout << "HierarchicalNavigationImpl this: " << this << std::endl;
    this->componentContext = static_cast<DataServerContext*>(componentContext);
}

HierarchicalNavigationImpl::~HierarchicalNavigationImpl()
{
  std::cout << "~HierarchicalNavigationImpl this: " << this << std::endl;
}

DataDescriptionSeq * HierarchicalNavigationImpl::getRoots() 
{
    std::cout << "[getRoots BEGIN]" << std::endl;
    std::vector<std::string> dirList;
   
    std::string rootPath( componentContext->getRootPath()); 
    std::cout << "   getDirList: " << rootPath << std::endl;
    dirList.push_back(rootPath);
    
    DataDescriptionSeq * dataList = new DataDescriptionSeq(dirList.size());
    dataList->length(dirList.size());
    
    DataServiceImpl * dataService = componentContext->IDataService();

    DataDescription_var desc;
    for (unsigned int i = 0 ; i < dirList.size() ; i++ )
    {
        std::cout << "Root: " << dirList[i] << std::endl;
        desc = dataService->createDataDescription(dirList[i]);
        (*dataList)[i] = desc;
    }

    std::cout << "[getRoots END]" << std::endl;
    return dataList;
}

DataDescriptionSeq * HierarchicalNavigationImpl::getChildren( const DataKey &  key ) 
{
    std::cout << "[getChildren BEGIN]" << std::endl;
    
    if(!componentContext->verifyPermission( key ))
        throw DataAccessDenied();

    DataKeyWrapper keyWrapper = DataKeyWrapper(key);
    std::string path = keyWrapper.dataId();

    if (!isDir(path))
    {
      throw ServiceFailure(); // "parentKey não é um diretório."
    }
    
    std::vector<std::string> dirList;
    getDirList(path , dirList); 
    
    DataDescriptionSeq * dataList = new DataDescriptionSeq(dirList.size());
    dataList->length(dirList.size());

    DataServiceImpl * dataService = componentContext->IDataService();
    DataDescription_var desc;
    for (unsigned int i =0 ; i < dirList.size() ; i++ )
    {
        std::cout << "Children: " << dirList[i] << std::endl;
        desc = dataService->createDataDescription( dirList[i] );
        (*dataList)[i] = desc;
    }

    std::cout << "[getChildren END]" << std::endl;
    return dataList;
}

DataDescription * HierarchicalNavigationImpl::getParent( const DataKey &  key )
{
    std::cout << "[getParent BEGIN]" << std::endl;
    if(!componentContext->verifyPermission( key ))
        throw DataAccessDenied();

    DataKeyWrapper keyWrapper(key);
    std::string path = keyWrapper.dataId();
    char * file    = strdup(path.c_str());
    char * dirpath = dirname(file);

    std::string parentDir(dirpath);

    if( (dirpath != NULL) && (! isDir(parentDir) ))
    {
        free(file);
        throw ServiceFailure();//"Erro ao ler o diretório pai."
    }

    free(file);
    DataServiceImpl * dataService = componentContext->IDataService();
    DataDescription * desc = dataService->createDataDescription(parentDir);
    std::cout << "[getParent END]" << std::endl;
    return desc; 
}

} } } } } } }

