#ifndef HIERARCHICALMANAGEMENTIMPL_V1_02_H_
#define HIERARCHICALMANAGEMENTIMPL_V1_02_H_

#include <scs/ComponentContext.h>
#include "DataServerContext.h"

#include <stubs/hierarchical_data_service.h>

namespace tecgraf { namespace openbus { namespace data_service { namespace core {
namespace v1_02 { namespace demo { namespace file_system {

/** 
 * @brief Implementação do serviço de dados 
 */
class HierarchicalManagementImpl
  : virtual public POA_tecgraf::openbus::data_service::hierarchical::v1_02::IHierarchicalManagementDataService
{
public:
  virtual ~HierarchicalManagementImpl();

  virtual DataKey * createData(const DataDescription &  fPrototype, const DataKey &  fParentKey ) 
    throw( CORBA::SystemException , 
           ServiceFailure         , 
           InvalidDataKey         , 
           DataNotFound           , 
           hierarchical::v1_02::InvalidPrototype       , 
           DataAccessDenied       , 
           hierarchical::v1_02::UnsupportedOperation   , 
           DataAlreadyExist       );


  virtual DataKey * copyData( const DataKey &  parentKey , 
                              const DataKey &  sourceKey )
    throw( CORBA::SystemException , 
           ServiceFailure         , 
           InvalidDataKey         ,
           DataNotFound           ,
           DataAccessDenied       ,
           hierarchical::v1_02::UnsupportedOperation   , 
           DataAlreadyExist       );


  virtual void moveData( const DataKey &  key, const DataKey &  newParentKey )
    throw( CORBA::SystemException , 
           ServiceFailure         ,
           InvalidDataKey         ,
           DataNotFound           , 
           DataAccessDenied       ,
           hierarchical::v1_02::UnsupportedOperation   , 
           DataAlreadyExist       );

  virtual void updateData( const DataKey &  key, const DataKey &  sourceKey )
    throw( CORBA::SystemException , 
           ServiceFailure         , 
           AbsentViews            , 
           InvalidDataKey         , 
           DataNotFound           , 
           hierarchical::v1_02::UnsupportedOperation   , 
           DataAccessDenied       );
  
  virtual void deleteData( const DataKey &  key )
    throw( CORBA::SystemException , 
           ServiceFailure         , 
           InvalidDataKey         , 
           DataNotFound           , 
           hierarchical::v1_02::UnsupportedOperation   , 
           DataAccessDenied       );
  
  /** 
   * @brief 
   * 
   * @param componentContext
   */
  HierarchicalManagementImpl( scs::core::ComponentContext * componentContext );
  
private:
  DataServerContext * componentContext;

  // Prevent copying and assigment of servants
  HierarchicalManagementImpl( HierarchicalManagementImpl & obj ){}
  void operator=( HierarchicalManagementImpl & obj ){}

};
      
} } } } } } }

#endif // HIERARCHICALMANAGEMENTIMPL_V1_02_H_
