#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "HierarchicalManagementImpl.h"
#include "DataServerContext.h"
#include "FileDataViewImpl.h"
#include "FileSystemUtils.h"

#include <iostream>

namespace tecgraf { namespace openbus { namespace data_service { namespace core {
namespace v1_02 { namespace demo { namespace file_system {

HierarchicalManagementImpl::HierarchicalManagementImpl( scs::core::ComponentContext * componentContext )
{
    this->componentContext = static_cast<DataServerContext*>(componentContext);
}

HierarchicalManagementImpl::~HierarchicalManagementImpl()
{
}

DataKey * HierarchicalManagementImpl::createData( const DataDescription &  prototype , 
                                       const DataKey &  parentKey  )
    throw( CORBA::SystemException , 
                    ServiceFailure         , 
                    InvalidDataKey         , 
                    DataNotFound           , 
                    hierarchical::v1_02::InvalidPrototype       , 
                    DataAccessDenied       , 
                    hierarchical::v1_02::UnsupportedOperation   , 
                    DataAlreadyExist       )
{
    std::cout << "[createData BEGIN]" << std::endl;

    if(!componentContext->verifyPermission( parentKey ))
        throw DataAccessDenied();

    DataKeyWrapper keyWrapper(parentKey);
    std::string parentPath = keyWrapper.dataId();

    if (!isDir(parentPath))
      throw ServiceFailure(); // "parentKey não é um diretório."

    std::string dataPath( parentPath.c_str() );
    dataPath+= "/" ;
    dataPath+= prototype.fName;

    std::cout << "dataPath: "<< dataPath << std::endl;
    
    DefaultView * defView =(DefaultView *) &(prototype.fDefaultView);
    if((defView == NULL)||((defView->fValue) == NULL))
    {
        std::cout << "Invalid DefaultView " << std::endl;
        throw ServiceFailure();
    }
    hierarchical::v1_02::HierarchicalNodeDataView*
      hNode = hierarchical::v1_02::HierarchicalNodeDataView::_downcast(defView->fValue->_to_value());

    if (hNode->fIsContainer()) {
      if( mkdir(dataPath.c_str(),0775) != 0 )
        throw ServiceFailure(); //"Erro ao criar o diretório."
    }
    else {
      if(creat(dataPath.c_str(),0664) == -1)
        throw ServiceFailure(); //"Erro ao criar o arquivo."
    }

    std::cout << "[createData END]" << std::endl;
    keyWrapper.dataId(dataPath);
    return new DataKey(keyWrapper.dataKey());
}

void HierarchicalManagementImpl::deleteData( const DataKey &  key )
    throw( CORBA::SystemException , 
                    ServiceFailure         , 
                    InvalidDataKey         , 
                    DataNotFound           , 
                    hierarchical::v1_02::UnsupportedOperation   , 
                    DataAccessDenied       )
{
    std::cout << "[deleteData BEGIN]" << std::endl;

    if(!componentContext->verifyPermission( key ))
        throw DataAccessDenied();

    DataKeyWrapper keyWrapper(key);
    std::string path = keyWrapper.dataId();

    std::cout << "delete: " << path << std::endl;
    bool ret = deleteDir(path);
    if (!ret)
      throw ServiceFailure(); //"Não é possível remover este arquivo"
    std::cout << "[deleteData END]" << std::endl;
}

DataKey * HierarchicalManagementImpl::copyData( const DataKey &  parentKey , 
                            const DataKey &  sourceKey )
    throw( CORBA::SystemException , 
                    ServiceFailure         , 
                    InvalidDataKey         ,
                    DataNotFound           ,
                    DataAccessDenied       ,
                    hierarchical::v1_02::UnsupportedOperation   , 
                    DataAlreadyExist       )
{
    throw ServiceFailure(); //"Not implemented"
    return NULL;
}

void HierarchicalManagementImpl::moveData( const DataKey &  key, const DataKey &  newParentKey )
    throw( CORBA::SystemException , 
                    ServiceFailure         ,
                    InvalidDataKey         ,
                    DataNotFound           , 
                    DataAccessDenied       ,
                    hierarchical::v1_02::UnsupportedOperation   , 
                    DataAlreadyExist       )
{
    throw ServiceFailure(); //"Not implemented"
    return;
}

void HierarchicalManagementImpl::updateData( const DataKey &  key, const DataKey &  sourceKey )
    throw( CORBA::SystemException , 
                    ServiceFailure         , 
                    AbsentViews            , 
                    InvalidDataKey         , 
                    DataNotFound           , 
                    hierarchical::v1_02::UnsupportedOperation   , 
                    DataAccessDenied       )
{
    throw ServiceFailure(); //"Not implemented"
    return;
}

} } } } } } }
