#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <dirent.h>
#include <libgen.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>

#include "FileSystemUtils.h"

namespace tecgraf { namespace openbus { namespace data_service { namespace core {
namespace v1_02 { namespace demo { namespace file_system {

bool isDir(std::string const& path )
{
    struct stat buf;
    if( stat(path.c_str(),&buf) != 0 ){
        std::string msg("path: ");
        msg += path ;
        msg += "\nerror: ";
        msg += strerror(errno);
        throw InvalidPath(msg); //"Não foi possivel ler o arquivo/pasta requisitado."
    }

    return S_ISDIR(buf.st_mode);
}


int getDirList (std::string const& dir, std::vector<std::string> &files)
{
    DIR *dp;
    struct dirent *dirp;
    if((dp  = opendir(dir.c_str())) == NULL) {
        std::string msg("path: ");
        msg += dir ;
        msg += "\nerror: ";
        msg += strerror(errno);
        throw InvalidPath(msg); //"Não foi possivel ler o arquivo/pasta requisitado."
    }

    while ((dirp = readdir(dp)) != NULL) {
        if(( strcmp(dirp->d_name, ".") != 0 )&&( strcmp(dirp->d_name, "..") != 0 )) 
        {
            std::string childname(dir);
            childname += "/";
            childname += dirp->d_name;
            files.push_back(childname);
        }
    }
    closedir(dp);
    return 0;
}

bool deleteDir(std::string const& path)
{
  if (isDir(path))
  {
    std::vector<std::string> children;
    getDirList(path,children);
    
    for (size_t i = 0; i < children.size() ; i++) {
      bool success = deleteDir( children[i] );
      if (!success) {
        return false;
      }
    }
  }

  return (remove(path.c_str())==0);
}

} } } } } } }
