#ifndef DATASERVICETESTER_V1_02_H_
#define DATASERVICETESTER_V1_02_H_

#include <scs/ComponentContext.h>

#include "stubs/hierarchical_data_service.h"

#include <sstream>

namespace tecgraf { namespace openbus { namespace data_service { namespace core {
namespace v1_02 {

} }

} } }

/** 
 * @brief Classe responsável por exercitar algumas funcionalidades do
 * serviço de dados. 
 */
class DataServiceTester
{
public:
  // Construtor e destrutor
  DataServiceTester( scs::core::IComponent * dataservice);
  ~DataServiceTester();

  // Executa os testes
  bool run();

private:
  // Referecia ao serviço de dados
  scs::core::IComponent * _icomponent;
  tecgraf::openbus::data_service::core::v1_02::IDataService * _dataService;
  tecgraf::openbus::data_service::hierarchical::v1_02::IHierarchicalManagementDataService_var _management;
  tecgraf::openbus::data_service::project::v1_02::IProjectNavigationDataService_var _navigation;
  tecgraf::openbus::data_service::hierarchical::v1_02::IHierarchicalTransferDataService_var _transfer;
        
  // Metodos de teste
  bool createTestData();
  bool readDataDescriptions();
  bool testILogView();
  bool testProject();
  bool testDeactivateLogInterface();
  bool destroyTestData();
  void printTree();
        
  // Metodos auxiliares
  void printTreeAux( tecgraf::openbus::data_service::core::v1_02::DataDescription* file , 
                     std::ostringstream& treeText   , 
                     unsigned char indent);
  void printFileData( tecgraf::openbus::data_service::core::v1_02::DataDescription* file );
  tecgraf::openbus::data_service::core::v1_02::DataKey * createData
    (tecgraf::openbus::data_service::core::v1_02::DataKey& parentKey, const char* name , bool container);
};


#endif

