#ifndef DATASERVICEIMPL_V1_02_H_
#define DATASERVICEIMPL_V1_02_H_

#include <scs/ComponentContext.h>
#include "DataServerContext.h"
#include "ftc/DefaultDataProvider.h"
#include "ftc/FTCServerConfig.h"
#include "ftc/FTCServer.h"
#include <pthread.h>

#include <vector>
#include <stubs/data_service.h>

namespace tecgraf { namespace openbus { namespace data_service { namespace core {
namespace v1_02 { namespace demo { namespace file_system {

namespace ftc = tecgraf::ftc::v1_04_01;
     
/** 
 * @brief Implementação do serviço de dados 
 */
class DataServiceImpl : virtual public POA_tecgraf::openbus::data_service::core::v1_02::IDataService
{
public:
  
  /** 
   * @brief 
   * 
   * @param componentContext
   * 
   * @return 
   */

  virtual ~DataServiceImpl( );

  
  virtual DataDescription * getDataDescription( const DataKey &  key )
    throw( CORBA::SystemException , 
           ServiceFailure         , 
           InvalidDataKey         , 
           DataNotFound           , 
           DataAccessDenied       );


  virtual DataView_ptr getDataView( const DataKey &  key, const char*  viewInterface )
    throw( CORBA::SystemException , 
           ServiceFailure         , 
           InvalidDataKey         ,
           DataNotFound           , 
           UnsupportedView        , 
           DataAccessDenied       );

  virtual DataViewSeq * getDataViewSeq( const DataKeySeq &  keys
                                        , const char*  viewInterface ) 
    throw( CORBA::SystemException , 
           ServiceFailure         ,
           InvalidDataKey         ,
           DataNotFound           , 
           UnsupportedView        ,
           DataAccessDenied       );

  DataView * createDataView( const DataKey & key, std::string & viewInterface, bool isContainer) ;
  DataDescription * createDataDescription(std::string name);
  void getViews(std::string & file, std::vector<std::string> & views, bool isContainer);

  /** 
   * @brief 
   * 
   * @param componentContext
   */
  DataServiceImpl( scs::core::ComponentContext * componentContext );
private:
  DataServerContext * componentContext;

  ftc::DefaultDataProvider ftc_file_provider;
  ftc::FTCServerConfig ftc_config;
  ftc::FTCServer ftc_server;
  pthread_t ftc_thread;

  static void* FTCLoop(void*);

  // Prevent copying and assigment of servants
  DataServiceImpl(DataServiceImpl const& obj);
  DataServiceImpl& operator=(DataServiceImpl const& obj);
};
      
} } } } } } }

#endif  // DATASERVICEIMPL_V1_02_H_
