#include <openssl/md5.h>

#include <HierarchicalNodeDataViewImpl.h>

#include "DataServiceImpl.h"
#include "UnstructuredDataViewImpl.h"
#include "DataServerContext.h"
#include "FileDataViewImpl.h"
#include "FileSystemUtils.h"
#include "ILogFileViewImpl.h"

namespace tecgraf { namespace openbus { namespace data_service { namespace core {
namespace v1_02 { namespace demo { namespace file_system {

namespace hierarchical_api = tecgraf::openbus::data_service::hierarchical::v1_02;

DataServiceImpl::DataServiceImpl( scs::core::ComponentContext * context )
  : ftc_server(ftc_file_provider, ftc_config)
{
    this->componentContext = static_cast<DataServerContext*>(context);

    if(pthread_create(&ftc_thread, 0, &DataServiceImpl::FTCLoop, this) != 0)
      throw std::runtime_error("Error creating thread");
}

void* DataServiceImpl::FTCLoop(void* obj)
{
  DataServiceImpl* self = static_cast<DataServiceImpl*>(obj);
  self->ftc_server.dispatch ();
  return 0;
}

DataServiceImpl::~DataServiceImpl()
{
  ftc_server.stop ();
  pthread_join (ftc_thread, 0);
}

DataDescription * DataServiceImpl::getDataDescription( const DataKey &  key )
    throw( CORBA::SystemException , 
                    ServiceFailure         , 
                    InvalidDataKey         , 
                    DataNotFound           , 
                    DataAccessDenied       )
{
    std::cout << "[getDataDescription BEGIN]" << std::endl;
    DataKeyWrapper keyWrapper(key);

    std::string path = keyWrapper.dataId();
    DataDescription * desc = createDataDescription(path);

    std::cout << "[getDataDescription END]" << std::endl;
    return desc;
}


DataView_ptr DataServiceImpl::getDataView( const DataKey &  key, const char*  viewInterface )
    throw( CORBA::SystemException , 
                    ServiceFailure         , 
                    InvalidDataKey         ,
                    DataNotFound           , 
                    UnsupportedView        , 
                    DataAccessDenied       )
{
    std::cout << "[getDataView BEGIN]" << std::endl;
    DataKeyWrapper keyWrapper(key);
    
    std::string path = keyWrapper.dataId();

    bool isContainer = isDir(path);
    std::vector<std::string> views;
    getViews(path,views,isContainer);

    std::string dataViewInterface(viewInterface);

    std::cout << "getDataView views.size: " << views.size()  << std::endl;
    std::cout << "getDataView viewInterface: " << viewInterface << std::endl;
    for (size_t i = 0; i < views.size(); i++) {
      std::cout << "view: " << views[i] << std::endl;
      if (views[i] == viewInterface )
        return createDataView(key, dataViewInterface,isContainer);
    }
    std::cout << "[getDataView END]" << std::endl;

    return NULL;
}

DataViewSeq * DataServiceImpl::getDataViewSeq( const DataKeySeq &  keys   ,
                                      const char*  viewInterface ) 
    throw( CORBA::SystemException , 
                    ServiceFailure         ,
                    InvalidDataKey         ,
                    DataNotFound           , 
                    UnsupportedView        ,
                    DataAccessDenied       )
{
    std::cout << "[getDataViewSeq BEGIN]" << std::endl;
    DataViewSeq_var dataViewSeq = new DataViewSeq(keys.length()); 
    dataViewSeq->length(keys.length());
    std::string dataInterface(viewInterface);
    for (unsigned int i = 0; i < keys.length(); i++)
    {
        DataKeyWrapper keyWrapper(keys[i]);
      
        if(!componentContext->verifyPermission( keys[i] ))
          throw DataAccessDenied();
    
        std::string path = keyWrapper.dataId();
        bool isContainer = isDir(path);
        std::vector<std::string> views;
        getViews(path,views,isContainer);

        DataView * view ;
        for (size_t j = 0; j < views.size(); j++) {
            if (views[j] == viewInterface )
            {
                view = createDataView(keys[i],dataInterface,isContainer);
                break;
            }
        }
        if( view == NULL )
            throw UnsupportedView();
        dataViewSeq[i] = view;
    }
    std::cout << "[getDataViewSeq END]" << std::endl;
    return dataViewSeq;
}



DataView * DataServiceImpl::createDataView( const DataKey & key, std::string & viewInterface, bool isContainer) 
{
    std::cout << "createDataView viewInterface: "<< viewInterface << std::endl;

    PortableServer::POA * poa = componentContext->getPOA();

    if ( viewInterface == hierarchical_api::_tc_HierarchicalNodeDataView->id() )
    {
        const DataKey parentKey;//FIXME: find the parent key
        hierarchical_api::HierarchicalNodeDataView* hNode = new hierarchical_api::HierarchicalNodeDataViewImpl
          (key, parentKey, isContainer);
        CORBA::AbstractBase* ab = hNode;
        return DataView::_narrow(ab);
    }
    else if ( viewInterface == _tc_UnstructuredDataView->id() ) {
      //TODO: code here depends on c++ ftc server implementation;
      DataKeyWrapper keyWrapper(key);
      std::string file = keyWrapper.dataId();

      unsigned char keystr[MD5_DIGEST_LENGTH];
      MD5((const unsigned char*)file.c_str(), file.size(), keystr );

      OctetSeq_var access_key(new OctetSeq);
      access_key->length(MD5_DIGEST_LENGTH);
      for(int i = 0; i != MD5_DIGEST_LENGTH; ++i)
        (*access_key)[i] = keystr[i];

      ftc::AccessKey akey( keystr , MD5_DIGEST_LENGTH, true );
      ftc_server.register_data_channel_info( NULL , file , &akey );
      
      UnstructuredDataViewImpl* 
        view = new UnstructuredDataViewImpl(key, "localhost", 25555, access_key, true);

      CORBA::AbstractBase* ab = view;
      return DataView::_narrow(ab);
    }
    else if ( viewInterface == _tc_LogFileValueTypeDataView->id() ) {
      try {
        PortableServer::ServantBase_var file_impl = new ILogFileImpl;
        CORBA::Object_var obj = poa->servant_to_reference(file_impl.in());
        LogFileValueTypeDataViewImpl* fileView = new
          LogFileValueTypeDataViewImpl(componentContext, key, file_system::ILogFile::_narrow(obj));;
        CORBA::AbstractBase* ab = fileView;
        return DataView::_narrow(ab);
      }
      catch (CORBA::SystemException & e) {
        std::cout << "Error: "<< e << std::endl;
      }
    }
    std::abort();
}

/** 
 * @brief 
 * 
 * @param name
 * 
 * @return 
 */
DataDescription * DataServiceImpl::createDataDescription(std::string name)
{
    bool isContainer = isDir(name);
    std::vector<std::string> viewsList;
    getViews(name,viewsList, isContainer);

    StringSeq_var views = new StringSeq(viewsList.size());
    views->length(viewsList.size());

    for (size_t i = 0; i < viewsList.size(); i++) {
        (*views)[i] = viewsList[i].c_str();
    }

    DataKeyWrapper keyWrapper(componentContext->entityName()
                              , componentContext->datasource_id()
                              , name);

    DataKey key = keyWrapper.dataKey();

    const MetadataSeq metadata(0);
    std::string viewInterface(hierarchical_api::_tc_HierarchicalNodeDataView->id());
    DataView_var view = createDataView(key,viewInterface,isContainer); 

    struct DefaultView defaultView;
    defaultView.fInterfaceName = hierarchical_api::_tc_HierarchicalNodeDataView->id();
    defaultView.fValue = view ;

    std::cout << "DataDescription: " << name.c_str() << std::endl;

    DataDescription * desc = new DataDescription;
    desc->fKey = key;
    desc->fName = name.c_str();
    desc->fDefaultView = defaultView; 
    desc->fOthersViews = views;
    desc->fMetadata = metadata;

    return desc;
}

void DataServiceImpl::getViews(std::string & file, std::vector<std::string> & views, bool isContainer)
{
    views.push_back(hierarchical_api::_tc_HierarchicalNodeDataView->id());
    if(!isContainer)
    {
        size_t dotPos = file.find_last_of('.');

        views.push_back(_tc_UnstructuredDataView->id());
        // views.push_back(_tc_FileDataView->id());
        views.push_back(project::v1_02::_tc_ProjectItemDataView->id());

        if ( file.find("log",dotPos) != std::string::npos ) {
            views.push_back(_tc_LogFileValueTypeDataView->id());
        }
    }
    else
      views.push_back(project::v1_02::_tc_ProjectDataView->id());
}

} } } } } } }
