#ifndef DATASERVERCONTEXT_V1_02_H
#define DATASERVERCONTEXT_V1_02_H

#include <vector>
#include <scs/ComponentContext.h>
#include <DataKeyWrapper.h>

namespace tecgraf { namespace openbus { namespace data_service { namespace core {
namespace v1_02 { namespace demo { namespace file_system {

class DataServiceImpl;
class HierarchicalManagementImpl;
class ProjectNavigationImpl;
class HierarchicalTransferImpl;

class DataServerContext : public scs::core::ComponentContext
{
public:
  DataServerContext(CORBA::ORB_var orb, scs::core::ComponentId id, const char * root_path
                    , std::string entityName, std::string datasource_id);
  virtual ~DataServerContext();
                                    
  virtual DataServiceImpl * IDataService();
  virtual HierarchicalManagementImpl * IHierarchicalManagement();
  virtual ProjectNavigationImpl * IHierarchicalNavigation();
  virtual HierarchicalTransferImpl * IHierarchicalTransfer();

  virtual const char * getRootPath();
  virtual void setRootPath( const char * rootPath );

  virtual std::string entityName() const { return entityName_; }
  virtual std::string datasource_id() const { return datasource_id_; }

  virtual bool verifyPermission(const DataKey & key);
private:
  std::string rootPath, entityName_, datasource_id_;
};

} } } } } } }

#endif // DATASERVERCONTEXT_V1_02_H
