
#include <stubs/data_service.h>
#include "stubs/file_system.h"
#include "DataServerContext.h"
#include "DataServiceImpl.h"
#include "HierarchicalManagementImpl.h"
#include "ProjectNavigationImpl.h"
#include "HierarchicalTransferImpl.h"

namespace tecgraf { namespace openbus { namespace data_service { namespace core {
namespace v1_02 { namespace demo { namespace file_system {

DataServerContext::DataServerContext(CORBA::ORB_var orb, scs::core::ComponentId id, const char * root_path
                                     , std::string entityName, std::string datasource_id)
  : ComponentContext(orb, id)
  , rootPath(root_path)
  , entityName_(entityName), datasource_id_(datasource_id)
{
}

DataServerContext::~DataServerContext()
{
}

DataServiceImpl * DataServerContext::IDataService()
{
  return dynamic_cast<DataServiceImpl*>(getFacetByName("data_service").servant);
}

HierarchicalManagementImpl * DataServerContext::IHierarchicalManagement()
{
  return dynamic_cast<HierarchicalManagementImpl*>(getFacetByName("management").servant);
}

ProjectNavigationImpl * DataServerContext::IHierarchicalNavigation()
{
  return dynamic_cast<ProjectNavigationImpl*>(getFacetByName("navigation").servant);
}

HierarchicalTransferImpl * DataServerContext::IHierarchicalTransfer()
{
  return dynamic_cast<HierarchicalTransferImpl*>(getFacetByName("transfer").servant);
}

void DataServerContext::setRootPath( const char * rootPath )
{
    this->rootPath = rootPath;
}

const char * DataServerContext::getRootPath()
{
    return this->rootPath.c_str();
}

bool DataServerContext::verifyPermission( const DataKey & key)
{
    return true;
}

} } } } } } }
