/*
** OpenBus Demo - Orbix 6.3
** client.cpp
*/

#include <fstream>
#include <iostream>

#include <openbus/OpenBusContext.hpp>
#include <openbus/ORBInitializer.hpp>

#include "FileDataViewImpl.h"
#include "DataServiceTester.h"
#include "ILogFileViewImpl.h"
#include "ProjectDataViewImpl.h"

#include <DataService.h>

namespace offer_registry = tecgraf::openbus::core::v2_0::services::offer_registry;
namespace services = tecgraf::openbus::core::v2_0::services;
namespace access_control = tecgraf::openbus::core::v2_0::services::access_control;

namespace file_system = tecgraf::openbus::data_service::core::v1_02::demo::file_system;
namespace api = tecgraf::openbus::data_service::core::v1_02;
namespace hierarchical_api = tecgraf::openbus::data_service::hierarchical::v1_02;

static void registerTypes(CORBA::ORB * orb){
  // CORBA::ValueFactoryBase_var vf1 = new file_system::FileDataViewFactory();
  // orb->register_value_factory( file_system::_tc_FileDataView->id(), vf1.in());

  CORBA::ValueFactoryBase_var vf2 = new api::UnstructuredDataViewFactory();
  orb->register_value_factory( api::_tc_UnstructuredDataView->id(), vf2.in());

  CORBA::ValueFactoryBase_var vf3 = new hierarchical_api::HierarchicalNodeDataViewFactory();
  orb->register_value_factory( hierarchical_api::_tc_HierarchicalNodeDataView->id(), vf3.in());

  CORBA::ValueFactoryBase_var vf4 = new file_system::LogFileValueTypeDataViewFactory;
  orb->register_value_factory( file_system::_tc_LogFileValueTypeDataView->id(), vf4.in());

  namespace project = tecgraf::openbus::data_service::project::v1_02;

  CORBA::ValueFactoryBase_var vf5 = new project::ProjectDataViewFactory;
  orb->register_value_factory( project::_tc_ProjectDataView->id(), vf5.in());
}

struct onReloginCallback
{
  typedef void result_type;
  result_type operator()(openbus::Connection& c, access_control::LoginInfo info) const
  {
    do
    {
      try
      {
        c.loginByPassword("demo", "demo");
        break;
      }
      catch(tecgraf::openbus::core::v2_0::services::access_control::AccessDenied const& e)
      {
        std::cout << "Falha ao tentar realizar o login por senha no barramento: "
          "a entidade j est com o login realizado. Esta falha ser ignorada." << std::endl;
      }
      catch (services::ServiceFailure e)
      {
        std::cout << "Falha no servio remoto. Causa: " << std::endl;
      }
      catch (CORBA::TRANSIENT const&)
      {
        std::cout << "Erro de comunicacao. Verifique se o sistema se encontra "
          "ainda disponivel ou se sua conexao com o mesmo foi interrompida" << std::endl;
      }
      catch (CORBA::COMM_FAILURE const&)
      {
        std::cout << "Erro de comunicacao. Verifique se o sistema se encontra "
          "ainda disponivel ou se sua conexao com o mesmo foi interrompida" << std::endl;
      }
      catch (CORBA::OBJECT_NOT_EXIST const&)
      {
        std::cout << "Objeto remoto nao existe mais. Verifique se o sistema se encontra disponivel" << std::endl;
      }
      unsigned int t = 30u;
      do { t = sleep(t); } while(t);
    }
    while(true);
  }
};

int main(int argc, char** argv)
{
  // Inicializando CORBA e ativando o RootPOA
  CORBA::ORB_var orb = openbus::ORBInitializer(argc, argv);
  CORBA::Object_var o = orb->resolve_initial_references("RootPOA");
  PortableServer::POA_var poa = PortableServer::POA::_narrow(o);
  assert(!CORBA::is_nil(poa));
  PortableServer::POAManager_var poa_manager = poa->the_POAManager();
  poa_manager->activate();

  // Registrando as fabricas de valuetypes
  try {
    registerTypes(orb);
  } catch (CORBA::Exception & e) {
      std::cout << "** Nao foi possivel registrar as fabricas de valuetypes. **" << std::endl ;
    exit(-1);
  }

  // Construindo e logando conexao
  openbus::OpenBusContext* manager = dynamic_cast<openbus::OpenBusContext*>
    (orb->resolve_initial_references("OpenBusContext"));
  assert(manager != 0);
  std::auto_ptr <openbus::Connection> conn;

  do
  {
    try
    {
      conn = manager->createConnection("localhost", 2089);
      conn->onInvalidLogin( ::onReloginCallback());
      conn->loginByPassword("demo", "demo");
      manager->setDefaultConnection(conn.get());
      break;
    }
    catch(tecgraf::openbus::core::v2_0::services::access_control::AccessDenied const& e)
    {
      std::cout << "Falha ao tentar realizar o login por senha no barramento: "
        "a entidade j est com o login realizado. Esta falha ser ignorada." << std::endl;
    }
    catch (services::ServiceFailure e)
    {
      std::cout << "Falha no servio remoto. Causa: " << std::endl;
    }
    catch (CORBA::TRANSIENT const&)
    {
      std::cout << "Erro de comunicacao. Verifique se o sistema se encontra "
        "ainda disponivel ou se sua conexao com o mesmo foi interrompida" << std::endl;
    }
    catch (CORBA::COMM_FAILURE const&)
    {
      std::cout << "Erro de comunicacao. Verifique se o sistema se encontra "
        "ainda disponivel ou se sua conexao com o mesmo foi interrompida" << std::endl;
    }
    catch (CORBA::OBJECT_NOT_EXIST const&)
    {
      std::cout << "Objeto remoto nao existe mais. Verifique se o sistema se encontra disponivel" << std::endl;
    }
    unsigned int t = 30u;
    do { t = sleep(t); } while(t);
  }
  while(true);

  // Recebendo ofertas
  openbus::idl_or::ServicePropertySeq props;
  props.length(2);
  props[0].name  = "openbus.offer.entity";
  props[0].value = "file_system_cpp";
  props[1].name  = "openbus.component.interface";
  props[1].value = api::_tc_IDataService->id();

  try
  {
    openbus::idl_or::ServiceOfferDescSeq_var offers = manager->getOfferRegistry()->findServices(props);

    if(offers->length() > 0)
    {
        CORBA::ULong idx = 0;
        scs::core::IComponent_var component = offers[idx].service_ref;
    
        DataServiceTester tester(component);
       
        if(tester.run())
        {
            std::cout << "Teste executado com sucesso!" << std::endl;
        }
        else
        {
            std::cout << "Teste executado com ERROS!" << std::endl;
        }
    }
    else
    {
        std::cout << "No foi encontrado nenhum servico provendo a faceta data_service!" << std::endl;
    }

    conn->logout();
  }
  catch (services::ServiceFailure e)
  {
    std::cout << "Falha no servio remoto. Causa: " << std::endl;
  }
  catch (CORBA::TRANSIENT const&)
  {
    std::cout << "Erro de comunicacao. Verifique se o sistema se encontra "
      "ainda disponivel ou se sua conexao com o mesmo foi interrompida" << std::endl;
  }
  catch (CORBA::OBJECT_NOT_EXIST const&)
  {
    std::cout << "Objeto remoto nao existe mais. Verifique se o sistema se encontra disponivel" << std::endl;
  }
  catch (CORBA::COMM_FAILURE const&)
  {
    std::cout << "Erro de comunicacao. Verifique se o sistema se encontra "
      "ainda disponivel ou se sua conexao com o mesmo foi interrompida" << std::endl;
  }

  return 0;
}
