#ifndef CONFIG_H
#define CONFIG_H

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
# pragma once
#endif

#include <string>
#include <vector>
#include <ostream>
#include <boost/cstdint.hpp>

class Config
{
public:
  enum Operation {
    OP_READ,
    OP_WRITE
  };

  Config();

  int parse(int argc, char *argv[], std::ostream& out);
  const std::string& hostname() const;
  void hostname(const std::string& value);
  uint16_t port() const;
  void port(uint16_t value);
  std::size_t buffer_size() const;
  void buffer_size(std::size_t value);
  Operation operation() const;
  void operation(Operation value);
  const std::string& filename() const;
  void filename(const std::string& value);
  const std::vector<uint8_t>& key() const;
  void key(const std::vector<uint8_t>& value);
  int64_t size() const;
  void size(int64_t value);
  bool close() const;
  void close(bool value);
private:
  std::string m_hostname;
  uint16_t m_port;
  std::size_t m_buffer_size;
  std::string m_filename;
  std::vector<uint8_t> m_key;
  Operation m_operation;
  int64_t m_size;
  bool m_close;
};

#endif
