/** \file
 * \brief Attributes Table Flat API.
 * This will simplify the DLL export.
 *
 * See Copyright Notice in im_lib.h
 * $Id: Exp $
 */

#ifndef __IM_ATTRIB_FLAT_H_
#define __IM_ATTRIB_FLAT_H_

#if	defined(__cplusplus)
extern "C" {
#endif

imAttribTablePrivate* imAttribTableCreate(int hash_size);
void imAttribTableDestroy(imAttribTablePrivate* ptable);
int imAttribTableCount(imAttribTablePrivate* ptable);
void imAttribTableRemoveAll(imAttribTablePrivate* ptable);
const void* imAttribTableGet(const imAttribTablePrivate* ptable, const char *name, int *data_type, int *count);
void imAttribTableSet(imAttribTablePrivate* ptable, const char* name, int data_type, int count, const void* data);
void imAttribTableUnSet(imAttribTablePrivate* ptable, const char *name);
void imAttribTableCopyFrom(imAttribTablePrivate* ptable_dst, const imAttribTablePrivate* ptable_src);
void imAttribTableForEach(const imAttribTablePrivate* ptable, void* user_data, imAttribTableCallback attrib_func);

#if defined(__cplusplus)
}
#endif

#endif
