from PyQt5.QtWidgets import QMainWindow
from gui.myapp import Ui_MyApp
from rpncalc import RPNcalc


class AppController(QMainWindow, Ui_MyApp):
    def __init__(self):
        super().__init__()
        super().setupUi(self)
        self.rpn = RPNcalc()

        self.pushButton_clear.clicked.connect(self.inputViewer.clear)
        self.pushButton_0.clicked.connect(self.inputDigit_0)
        # **** COMPLETE HERE: APPCONTROLLER_01 ****
        self.pushButton_chs.clicked.connect(self.changeSign)
        self.pushButton_enter.clicked.connect(self.enterNumber)
        self.pushButton_div.clicked.connect(self.selectOp_div)
        # **** COMPLETE HERE: APPCONTROLLER_02 ****

    def inputDigit_0(self):
        text = self.inputViewer.text()
        self.inputViewer.setText(text + '0')

    # **** COMPLETE HERE: APPCONTROLLER_03 ****

    def changeSign(self):
        text = self.inputViewer.text()
        if text == "":
            return
        number = int(text)
        number *= -1
        self.inputViewer.setText(str(number))

    def enterNumber(self):
        text = self.inputViewer.text()
        if text == "":
            return
        number = int(text)
        self.rpn.enterNumber(number)
        self.displayStack()
        self.inputViewer.clear()

    def selectOp_div(self):
        text = self.inputViewer.text()
        if text == "":
            print("Two operands needed!\n")
            return
        number = int(text)
        if number == 0:
            print("Error: division by zero!\n")
            return
        self.rpn.selectOp_div(number)
        self.displayStack()
        self.inputViewer.clear()

    # **** COMPLETE HERE: APPCONTROLLER_04 ****

    def displayStack(self):
        text = self.rpn.stack.dump()
        self.stackViewer.setPlainText(text)
