%% Cross03
%
% This is a MATLAB program for solving a continuous beam using the
% Cross Process.
% Euler-Bernoulli flexural behavior is assumed (Navier beam theory).
%
% This program implements the Cross Process for continuous beams with
% uniformly distributed loads in each spam.
%
% For more details of this process, refer to the book "Anlise de
% Estruturas: Conceitos e Mtodos Bsicos", Second Edition, by Luiz
% Fernando Martha, Elsevier, 2017.
%
%% Object oriented classes
% This program adopts an Object Oriented Programming (OOP) paradigm, in
% which the following OOP classes are implemented:
%%%
% * <crosssolver.html *CrossSolver*> class.
% * <crossmember.html *CrossMember*> class.
% * <crossnode.html *CrossNode*> class.
% * <crossstep.html *CrossStep*> class.
% * <crossdraw.html *CrossDraw*> class.
% * <crosscontrol.html *CrossControl*> class.
% * <crossgui.html *CrossGUI*> class.
% * <canvas.html *Canvas*> class.
% * <canvas_2d.html *Canvas_2D*> class
% * <canvascross.html *CanvasCross*> class
%
%% Author
% Luiz Fernando Martha
%
%% History
% @version 1.02
%
% Initial version 1.00: September 2025
%%%
% Initially prepared for version Cross01 application of course CIV 2801 -
% Fundamentos de Computao Grfica, 2025, second term, Department of
% Civil Engineering, PUC-Rio.
% Cross01 version has no canvas and controls the continuous beam Cross
% solution through control buttons.
%
% Version 1.01: September 2025
%%%
% Cross02 version: added model canvas and display of continuous beam model.
%
% Version 1.02: October 2025
%%%
% Cross03 version: implementation of drawing of deformed configuration and
% bending moment diagram.
%

%% Initialization

% Clear workspace
clear
close(findall(0,'Type','figure'));
clear classes
clc

% Add path to canvas, cross, and images folders
addpath('canvas','cross','gui','images');

%% Start up app
CrossGUI
%CrossGUI_code
