%% Read file Function
%
% This is an auxiliary file of the <main.html LESM> (Linear Elements
% Structure Model) program that contains functions to read a neutral-format
% file with the _.lsm_ extension 
% This neutral-format file contains all information about a linear elements
% structural model.
%
%% Authors
% Luiz Fernando Martha, Rafael Lopez Rangel and Pedro Cortez Lopes
%
%% Main function
% Output:
%  vs:      flag for version compatibility
%  print:   object of the Print class
%  draw:    object of the Draw class
%  nclc:    current load case id
% Input arguments:
%  fid: integer identifier of the input file
%  drv: handle to an object of the Drv class
function [vs,print,draw,nclc,nfixed,nspring] = readFile(fid,drv,GUI_Mode)
    if nargin == 2
        GUI_Mode = true;
    end
    % Reads input file
    flag = 1;
    while flag
        % Get file line
        tline = fgetl(fid);
        % Get rid of blank spaces
        string = deblank(tline);
        
        % Look for for tag strings
        switch string
            case '%HEADER.VERSION'
                [vs,version] = readVersion(fid);
                if (version == 1.0) || (version == 1.1)
                    [f,print,draw,nclc,nfixed,nspring] = readFile_v1(fid,drv,flag,GUI_Mode); 
                elseif version == 2.0
                    [f,print,draw,nclc,nfixed,nspring] = readFile_v2(fid,drv,flag,GUI_Mode);
                else
                    nclc = 0;
                    nfixed = 0;
                    nspring = 0;
                    print = [];
                    draw = [];
                    return
                end
                flag = f;
        end
    end
    
    % Close file
    fclose(fid);
end

%% Auxiliary functions
%--------------------------------------------------------------------------
function [vs,version] = readVersion(fid)
    % Read program version number
    version = fscanf(fid,'%f',1);
    
    % Check version compatibility
    if (version == 1.0) || (version == 1.1)  || (version == 2.0)
        vs = 1;
    else
        vs = 0;
        return
    end
end

