%% Support Dialog Callback Functions
% This file contains the callback functions associated with the "Supports"
% dialog of the graphical version of the LESM program.
% Common input arguments for all callback functions:
%  hObject: handle to interface object related to the function
%  eventdata: reserved - to be defined in a future version of MATLAB
%  handles: structure with handles and user data
%
%% Authors
% Luiz Fernando Martha, Rafael Lopez Rangel and Pedro Cortez Lopes
%
%% ------------------------------------------------------------------------
% GUI initialization function.
function varargout = GUI_Supports(varargin)
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @GUI_Supports_OpeningFcn, ...
                   'gui_OutputFcn',  @GUI_Supports_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end

%--------------------------------------------------------------------------
% Executes just before Supports GUI is made visible.
% Sets GUI initial properties.
function GUI_Supports_OpeningFcn(hObject, eventdata, handles, varargin) %#ok<*INUSL>
% Choose default command line output for GUI_NodalLoads
handles.output = hObject;

% Move GUI to the center of the screen
movegui(hObject,'center')

% Make GUI a modal window
set(hObject,'WindowStyle','modal');

% Get ID of selected node
nodes = getappdata(0,'nodes');
n = get(handles.popupmenu_Node,'Value');

% Set support or spring conditions of current node
if nodes(n).ebc(1) == 1
    set(handles.checkbox_Dx,'Value',1);
    set(handles.edit_Dx,'Enable','on');
    set(handles.checkbox_Kx,'Value',0);
    set(handles.edit_Kx,'Enable','off');
end

if nodes(n).ebc(2) == 1
    set(handles.checkbox_Dy,'Value',1);
    set(handles.edit_Dy,'Enable','on');
    set(handles.checkbox_Ky,'Value',0);
    set(handles.edit_Ky,'Enable','off');
end

if nodes(n).ebc(3) == 1
    set(handles.checkbox_Dz,'Value',1);
    set(handles.edit_Dz,'Enable','on');
    set(handles.checkbox_Kz,'Value',0);
    set(handles.edit_Kz,'Enable','off');
end

if nodes(n).ebc(4) == 1
    set(handles.checkbox_Rx,'Value',1);
    set(handles.edit_Rx,'Enable','on');
    set(handles.checkbox_Krx,'Value',0);
    set(handles.edit_Krx,'Enable','off');
end

if nodes(n).ebc(5) == 1
    set(handles.checkbox_Ry,'Value',1);
    set(handles.edit_Ry,'Enable','on');
    set(handles.checkbox_Kry,'Value',0);
    set(handles.edit_Kry,'Enable','off');
end

if nodes(n).ebc(6) == 1
    set(handles.checkbox_Rz,'Value',1);
    set(handles.edit_Rz,'Enable','on');
    set(handles.checkbox_Krz,'Value',0);
    set(handles.edit_Krz,'Enable','off');
end

if nodes(n).ebc(1) == 2
    set(handles.checkbox_Dx,'Value',0);
    set(handles.edit_Dx,'Enable','off');
    set(handles.checkbox_Kx,'Value',1);
    set(handles.edit_Kx,'Enable','on');
end

if nodes(n).ebc(2) == 2
    set(handles.checkbox_Dy,'Value',0);
    set(handles.edit_Dy,'Enable','off');
    set(handles.checkbox_Ky,'Value',1);
    set(handles.edit_Ky,'Enable','on');
end

if nodes(n).ebc(3) == 2
    set(handles.checkbox_Dz,'Value',0);
    set(handles.edit_Dz,'Enable','off');
    set(handles.checkbox_Kz,'Value',1);
    set(handles.edit_Kz,'Enable','on');
end

if nodes(n).ebc(4) == 2
    set(handles.checkbox_Rx,'Value',0);
    set(handles.edit_Rx,'Enable','off');
    set(handles.checkbox_Krx,'Value',1);
    set(handles.edit_Krx,'Enable','on');
end

if nodes(n).ebc(5) == 2
    set(handles.checkbox_Ry,'Value',0);
    set(handles.edit_Ry,'Enable','off');
    set(handles.checkbox_Kry,'Value',1);
    set(handles.edit_Kry,'Enable','on');
end

if nodes(n).ebc(6) == 2
    set(handles.checkbox_Rz,'Value',0);
    set(handles.edit_Rz,'Enable','off');
    set(handles.checkbox_Krz,'Value',1);
    set(handles.edit_Krz,'Enable','on');
end

% Get selected load case ID
mdata = guidata(findobj('Tag','GUI_Main'));
lc = get(mdata.popupmenu_LoadCase,'Value');

% Set selected node presc. displ.
if lc > size(nodes(n).nodalLoadCase,2)
    dx = num2str(0);
    dy = num2str(0);
    dz = num2str(0);
    rx = num2str(0);
    ry = num2str(0);
    rz = num2str(0);
else    
    dx = num2str(1e3*nodes(n).nodalLoadCase(7,lc));
    dy = num2str(1e3*nodes(n).nodalLoadCase(8,lc));
    dz = num2str(1e3*nodes(n).nodalLoadCase(9,lc));
    rx = num2str(nodes(n).nodalLoadCase(10,lc));
    ry = num2str(nodes(n).nodalLoadCase(11,lc));
    rz = num2str(nodes(n).nodalLoadCase(12,lc));
end

% Set selected node spring stiffness
if isempty (nodes(n).springStiff) == 0
    kx = num2str(nodes(n).springStiff(1));
    ky = num2str(nodes(n).springStiff(2));
    kz = num2str(nodes(n).springStiff(3));
    krx = num2str(nodes(n).springStiff(4));
    kry = num2str(nodes(n).springStiff(5));
    krz = num2str(nodes(n).springStiff(6));
else
    kx = num2str(0);
    ky = num2str(0);
    kz = num2str(0);
    krx = num2str(0);
    kry = num2str(0);
    krz = num2str(0);
end

% Unable constraints not used in the current analysis model and
% set node presc. displ. and spring stiffness
anm = get(mdata.popupmenu_Anm,'Value');
if anm == 1
    set(handles.checkbox_Dz,'Enable','off');
    set(handles.checkbox_Rx,'Enable','off');
    set(handles.checkbox_Ry,'Enable','off');
    set(handles.checkbox_Rz,'Enable','off');
    
    set(handles.edit_Dx,'String',dx)
    set(handles.edit_Dy,'String',dy)
    set(handles.edit_Dz,'String','')
    set(handles.edit_Rx,'String','')
    set(handles.edit_Ry,'String','')
    set(handles.edit_Rz,'String','')
    
    set(handles.checkbox_Kz,'Enable','off');
    set(handles.checkbox_Krx,'Enable','off');
    set(handles.checkbox_Kry,'Enable','off');
    set(handles.checkbox_Krz,'Enable','off');
    
    set(handles.edit_Kx,'String',kx)
    set(handles.edit_Ky,'String',ky)
    set(handles.edit_Kz,'String','')
    set(handles.edit_Krx,'String','')
    set(handles.edit_Kry,'String','')
    set(handles.edit_Krz,'String','')
    
elseif anm == 2
    set(handles.checkbox_Dz,'Enable','off');
    set(handles.checkbox_Rx,'Enable','off');
    set(handles.checkbox_Ry,'Enable','off');
    
    set(handles.edit_Dx,'String',dx)
    set(handles.edit_Dy,'String',dy)
    set(handles.edit_Dz,'String','')
    set(handles.edit_Rx,'String','')
    set(handles.edit_Ry,'String','')
    set(handles.edit_Rz,'String',rz)
    
    set(handles.checkbox_Kz,'Enable','off');
    set(handles.checkbox_Krx,'Enable','off');
    set(handles.checkbox_Kry,'Enable','off');
    
    set(handles.edit_Kx,'String',kx)
    set(handles.edit_Ky,'String',ky)
    set(handles.edit_Kz,'String','')
    set(handles.edit_Krx,'String','')
    set(handles.edit_Kry,'String','')
    set(handles.edit_Krz,'String',krz)
    
elseif anm == 3
    set(handles.checkbox_Dx,'Enable','off');
    set(handles.checkbox_Dy,'Enable','off');
    set(handles.checkbox_Rz,'Enable','off');
    
    set(handles.edit_Dx,'String','')
    set(handles.edit_Dy,'String','')
    set(handles.edit_Dz,'String',dz)
    set(handles.edit_Rx,'String',rx)
    set(handles.edit_Ry,'String',ry)
    set(handles.edit_Rz,'String','')
    
    set(handles.checkbox_Kx,'Enable','off');
    set(handles.checkbox_Ky,'Enable','off');
    set(handles.checkbox_Krz,'Enable','off');
    
    set(handles.edit_Kx,'String','')
    set(handles.edit_Ky,'String','')
    set(handles.edit_Kz,'String',kz)
    set(handles.edit_Krx,'String',krx)
    set(handles.edit_Kry,'String',kry)
    set(handles.edit_Krz,'String','') 
    
elseif anm == 4
    set(handles.checkbox_Rx,'Enable','off');
    set(handles.checkbox_Ry,'Enable','off');
    set(handles.checkbox_Rz,'Enable','off');
    
    set(handles.edit_Dx,'String',dx)
    set(handles.edit_Dy,'String',dy)
    set(handles.edit_Dz,'String',dz)
    set(handles.edit_Rx,'String','')
    set(handles.edit_Ry,'String','')
    set(handles.edit_Rz,'String','')
    
    set(handles.checkbox_Krx,'Enable','off');
    set(handles.checkbox_Kry,'Enable','off');
    set(handles.checkbox_Krz,'Enable','off');
    
    set(handles.edit_Kx,'String',kx)
    set(handles.edit_Ky,'String',ky)
    set(handles.edit_Kz,'String',kz)
    set(handles.edit_Krx,'String','')
    set(handles.edit_Kry,'String','')
    set(handles.edit_Krz,'String','')
    
elseif anm == 5
    set(handles.edit_Dx,'String',dx)
    set(handles.edit_Dy,'String',dy)
    set(handles.edit_Dz,'String',dz)
    set(handles.edit_Rx,'String',rx)
    set(handles.edit_Ry,'String',ry)
    set(handles.edit_Rz,'String',rz)
    
    set(handles.edit_Kx,'String',kx)
    set(handles.edit_Ky,'String',ky)
    set(handles.edit_Kz,'String',kz)
    set(handles.edit_Krx,'String',krx)
    set(handles.edit_Kry,'String',kry)
    set(handles.edit_Krz,'String',krz)
end

% Update handles structure
guidata(hObject, handles);

%--------------------------------------------------------------------------
% Outputs from this function are returned to the command line.
function varargout = GUI_Supports_OutputFcn(hObject, eventdata, handles)
% Get default command line output from handles structure
varargout{1} = handles.output;

%--------------------------------------------------------------------------
% Executes during popupmenu_Node creation, after setting all properties.
function popupmenu_Node_CreateFcn(hObject, eventdata, handles) %#ok<*INUSD,*DEFNU>
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
% Create list of nodes
nnp = getappdata(0,'nnp');
n = zeros(1,nnp);
for i = 1:nnp
    n(i) = i;
end
n = num2str(n,'%d\n');
set(hObject,'string',n)

%--------------------------------------------------------------------------
% Executes on node selection change.
function popupmenu_Node_Callback(hObject, eventdata, handles)
nodes = getappdata(0,'nodes');

% Get ID of selected node
n = get(hObject,'Value');

% Set selected node support conditions
if nodes(n).ebc(1) == 1
    set(handles.checkbox_Dx,'Value',1);
    set(handles.edit_Dx,'Enable','on');
    set(handles.checkbox_Kx,'Value',0);
    set(handles.edit_Kx,'Enable','off');
elseif nodes(n).ebc(1) == 2
    set(handles.checkbox_Dx,'Value',0);
    set(handles.edit_Dx,'Enable','off');
    set(handles.checkbox_Kx,'Value',1);
    set(handles.edit_Kx,'Enable','on');
else
    set(handles.checkbox_Dx,'Value',0);
    set(handles.edit_Dx,'Enable','off');
    set(handles.checkbox_Kx,'Value',0);
    set(handles.edit_Kx,'Enable','off');
end

if nodes(n).ebc(2) == 1
    set(handles.checkbox_Dy,'Value',1);
    set(handles.edit_Dy,'Enable','on');
    set(handles.checkbox_Ky,'Value',0);
    set(handles.edit_Ky,'Enable','off');
elseif nodes(n).ebc(2) == 2
    set(handles.checkbox_Dy,'Value',0);
    set(handles.edit_Dy,'Enable','off');
    set(handles.checkbox_Ky,'Value',1);
    set(handles.edit_Ky,'Enable','on');
else
    set(handles.checkbox_Dy,'Value',0);
    set(handles.edit_Dy,'Enable','off');
    set(handles.checkbox_Ky,'Value',0);
    set(handles.edit_Ky,'Enable','off');
end

if nodes(n).ebc(3) == 1
    set(handles.checkbox_Dz,'Value',1);
    set(handles.edit_Dz,'Enable','on');
    set(handles.checkbox_Kz,'Value',0);
    set(handles.edit_Kz,'Enable','off');
elseif nodes(n).ebc(3) == 2
    set(handles.checkbox_Dz,'Value',0);
    set(handles.edit_Dz,'Enable','off');
    set(handles.checkbox_Kz,'Value',1);
    set(handles.edit_Kz,'Enable','on');
else
    set(handles.checkbox_Dz,'Value',0);
    set(handles.edit_Dz,'Enable','off');
    set(handles.checkbox_Kz,'Value',0);
    set(handles.edit_Kz,'Enable','off');
end

if nodes(n).ebc(4) == 1
    set(handles.checkbox_Rx,'Value',1);
    set(handles.edit_Rx,'Enable','on');
    set(handles.checkbox_Krx,'Value',0);
    set(handles.edit_Krx,'Enable','off');
elseif nodes(n).ebc(4) == 2
    set(handles.checkbox_Rx,'Value',0);
    set(handles.edit_Rx,'Enable','off');
    set(handles.checkbox_Krx,'Value',1);
    set(handles.edit_Krx,'Enable','on');
else
    set(handles.checkbox_Rx,'Value',0);
    set(handles.edit_Rx,'Enable','off');
    set(handles.checkbox_Krx,'Value',0);
    set(handles.edit_Krx,'Enable','off');
end

if nodes(n).ebc(5) == 1
    set(handles.checkbox_Ry,'Value',1);
    set(handles.edit_Ry,'Enable','on');
    set(handles.checkbox_Kry,'Value',0);
    set(handles.edit_Kry,'Enable','off');
elseif nodes(n).ebc(5) == 2
    set(handles.checkbox_Ry,'Value',0);
    set(handles.edit_Ry,'Enable','off');
    set(handles.checkbox_Kry,'Value',1);
    set(handles.edit_Kry,'Enable','on');
else
    set(handles.checkbox_Ry,'Value',0);
    set(handles.edit_Ry,'Enable','off');
    set(handles.checkbox_Kry,'Value',0);
    set(handles.edit_Kry,'Enable','off');
end

if nodes(n).ebc(6) == 1
    set(handles.checkbox_Rz,'Value',1);
    set(handles.edit_Rz,'Enable','on');
    set(handles.checkbox_Krz,'Value',0);
    set(handles.edit_Krz,'Enable','off');
elseif nodes(n).ebc(6) == 2
    set(handles.checkbox_Rz,'Value',0);
    set(handles.edit_Rz,'Enable','off');
    set(handles.checkbox_Krz,'Value',1);
    set(handles.edit_Krz,'Enable','on');
else
    set(handles.checkbox_Rz,'Value',0);
    set(handles.edit_Rz,'Enable','off');
    set(handles.checkbox_Krz,'Value',0);
    set(handles.edit_Krz,'Enable','off');
end

% Get selected load case ID
mdata = guidata(findobj('Tag','GUI_Main'));
lc = get(mdata.popupmenu_LoadCase,'Value');

% Set selected node presc. displ.
if lc > size(nodes(n).nodalLoadCase,2)
    dx = num2str(0);
    dy = num2str(0);
    dz = num2str(0);
    rx = num2str(0);
    ry = num2str(0);
    rz = num2str(0);
else    
    dx = num2str(1e3*nodes(n).nodalLoadCase(7,lc));
    dy = num2str(1e3*nodes(n).nodalLoadCase(8,lc));
    dz = num2str(1e3*nodes(n).nodalLoadCase(9,lc));
    rx = num2str(nodes(n).nodalLoadCase(10,lc));
    ry = num2str(nodes(n).nodalLoadCase(11,lc));
    rz = num2str(nodes(n).nodalLoadCase(12,lc));
end

% Set node presc. displ.
anm = get(mdata.popupmenu_Anm,'Value');
if anm == 1
    set(handles.edit_Dx,'String',dx)
    set(handles.edit_Dy,'String',dy)
    set(handles.edit_Dz,'String','')
    set(handles.edit_Rx,'String','')
    set(handles.edit_Ry,'String','')
    set(handles.edit_Rz,'String','')
elseif anm == 2
    set(handles.edit_Dx,'String',dx)
    set(handles.edit_Dy,'String',dy)
    set(handles.edit_Dz,'String','')
    set(handles.edit_Rx,'String','')
    set(handles.edit_Ry,'String','')
    set(handles.edit_Rz,'String',rz)
elseif anm == 3
    set(handles.edit_Dx,'String','')
    set(handles.edit_Dy,'String','')
    set(handles.edit_Dz,'String',dz)
    set(handles.edit_Rx,'String',rx)
    set(handles.edit_Ry,'String',ry)
    set(handles.edit_Rz,'String','')
elseif anm == 4
    set(handles.edit_Dx,'String',dx)
    set(handles.edit_Dy,'String',dy)
    set(handles.edit_Dz,'String',dz)
    set(handles.edit_Rx,'String','')
    set(handles.edit_Ry,'String','')
    set(handles.edit_Rz,'String','')
elseif anm == 5
    set(handles.edit_Dx,'String',dx)
    set(handles.edit_Dy,'String',dy)
    set(handles.edit_Dz,'String',dz)
    set(handles.edit_Rx,'String',rx)
    set(handles.edit_Ry,'String',ry)
    set(handles.edit_Rz,'String',rz)
end

% Set selected node spring stiffness
if isempty(nodes(n).springStiff) == 0
    kx = num2str(nodes(n).springStiff(1));
    ky = num2str(nodes(n).springStiff(2));
    kz = num2str(nodes(n).springStiff(3));
    krx = num2str(nodes(n).springStiff(4));
    kry = num2str(nodes(n).springStiff(5));
    krz = num2str(nodes(n).springStiff(6));
else
    kx = num2str(0);
    ky = num2str(0);
    kz = num2str(0);
    krx = num2str(0);
    kry = num2str(0);
    krz = num2str(0);
end

% Set node spring stiffness
mdata = guidata(findobj('Tag','GUI_Main'));
anm = get(mdata.popupmenu_Anm,'Value');
if anm == 1
    set(handles.edit_Kx,'String',kx)
    set(handles.edit_Ky,'String',ky)
    set(handles.edit_Kz,'String','')
    set(handles.edit_Krx,'String','')
    set(handles.edit_Kry,'String','')
    set(handles.edit_Krz,'String','')
elseif anm == 2
    set(handles.edit_Kx,'String',kx)
    set(handles.edit_Ky,'String',ky)
    set(handles.edit_Kz,'String','')
    set(handles.edit_Krx,'String','')
    set(handles.edit_Kry,'String','')
    set(handles.edit_Krz,'String',krz)
elseif anm == 3
    set(handles.edit_Kx,'String','')
    set(handles.edit_Ky,'String','')
    set(handles.edit_Kz,'String',kz)
    set(handles.edit_Krx,'String',krx)
    set(handles.edit_Kry,'String',kry)
    set(handles.edit_Krz,'String','')
elseif anm == 4
    set(handles.edit_Kx,'String',kx)
    set(handles.edit_Ky,'String',ky)
    set(handles.edit_Kz,'String',kz)
    set(handles.edit_Krx,'String','')
    set(handles.edit_Kry,'String','')
    set(handles.edit_Krz,'String','')
elseif anm == 5
    set(handles.edit_Kx,'String',kx)
    set(handles.edit_Ky,'String',ky)
    set(handles.edit_Kz,'String',kz)
    set(handles.edit_Krx,'String',krx)
    set(handles.edit_Kry,'String',kry)
    set(handles.edit_Krz,'String',krz)
end

%--------------------------------------------------------------------------
% Executes on button press in "Set" pushbutton.
% Sets nodal supports and presc. displ. of a Node object.
function pushbutton_Set_Callback(hObject, eventdata, handles)
% Get handle to GUI_Main
mdata = guidata(findobj('Tag','GUI_Main'));

% Get variables from root
nodes = getappdata(0,'nodes');
drv = getappdata(0,'drv');

% Disable button while input data is being set
set(hObject,'enable','off')

% Initialize dof counters
countNewFree = 0;
countNewFixed = 0;
countNewSpring = 0;
countRemovedFree = 0;
countRemovedFixed = 0;
countRemovedSpring = 0;

% Get selected load case ID 
lc = get(mdata.popupmenu_LoadCase,'Value');

% Get ID of selected node
if ~get(handles.checkbox_MultiNodes,'value')
    n_ID = get(handles.popupmenu_Node,'Value');
else
    n_str = get(handles.edit_MultiNodes,'string');
    if strcmp(n_str,'all')
        n_ID = 1:getappdata(0,'nnp');
    elseif strcmp(n_str,'ALL')
        n_ID = 1:getappdata(0,'nnp');
    elseif strcmp(n_str,'All')
        n_ID = 1:getappdata(0,'nnp');
    else
        [flag,n_ID] = readStr(n_str,getappdata(0,'nnp'));
        if ~flag
            % Enable button for futre use
            set(hObject,'enable','on')
    
            msgbox('Invalid input data', 'Error','error');
            return
        end
    end
end

% Get constraint flags
Dx = get(handles.checkbox_Dx,'Value');
Dy = get(handles.checkbox_Dy,'Value');
Dz = get(handles.checkbox_Dz,'Value');
Rx = get(handles.checkbox_Rx,'Value');
Ry = get(handles.checkbox_Ry,'Value');
Rz = get(handles.checkbox_Rz,'Value');
ebc = [Dx, Dy, Dz, Rx, Ry, Rz];

% Get presc. displ.
dx = 1e-3*str2double(get(handles.edit_Dx,'String'));
if isnan(dx) == 1
    dx = 0;
end
dy = 1e-3*str2double(get(handles.edit_Dy,'String'));
if isnan(dy) == 1
    dy = 0;
end
dz = 1e-3*str2double(get(handles.edit_Dz,'String'));
if isnan(dz) == 1
    dz = 0;
end
rx = str2double(get(handles.edit_Rx,'String'));
if isnan(rx) == 1
    rx = 0;
end
ry = str2double(get(handles.edit_Ry,'String'));
if isnan(ry) == 1
    ry = 0;
end
rz = str2double(get(handles.edit_Rz,'String'));
if isnan(rz) == 1
    rz = 0;
end

if (isnan(dx)) || (isnan(dy)) || (isnan(dz)) || (isnan(rx)) || (isnan(ry)) || (isnan(rz))
    msgbox('Invalid input data', 'Error','error');
    return
end

if (dx ~= 0) || (dy ~= 0) || (dz ~= 0) || (rx ~= 0) || (ry ~= 0) || (rz ~= 0)
    prescDispl = [dx, dy, dz, rx, ry, rz];
else
    prescDispl = [];
end

% Get spring flags
springFlag = [get(handles.checkbox_Kx,'Value')
              get(handles.checkbox_Ky,'Value')
              get(handles.checkbox_Kz,'Value')
              get(handles.checkbox_Krx,'Value')
              get(handles.checkbox_Kry,'Value')
              get(handles.checkbox_Krz,'Value')];  


% Get spring stiffness
kx = str2double(get(handles.edit_Kx,'String'));
if isnan(kx) == 1
    kx = 0;    
end
ky = str2double(get(handles.edit_Ky,'String'));
if isnan(ky) == 1
    ky = 0;
end
kz = str2double(get(handles.edit_Kz,'String'));
if isnan(kz) == 1
    kz = 0;
end
krx = str2double(get(handles.edit_Krx,'String'));
if isnan(krx) == 1
    krx = 0;
end
kry = str2double(get(handles.edit_Kry,'String'));
if isnan(kry) == 1
    kry = 0;
end
krz = str2double(get(handles.edit_Krz,'String'));
if isnan(krz) == 1
    krz = 0;
end

if (kx < 0) || (ky < 0) || (kz < 0) || (krx < 0) || (kry < 0) || (krz <0)
    msgbox('Invalid input data - spring stiffness must be a non negative value','Error','error');
    return
end  

% Assemble spring flags in ebc vector
if (springFlag(1) == 1) && (kx > 0)
    ebc(1) = 2;
end    
if (springFlag(2) == 1) && (ky > 0)
    ebc(2) = 2;
end
if (springFlag(3) == 1) && (kz > 0)
    ebc(3) = 2;
end  
if (springFlag(4) == 1) && (krx > 0)
    ebc(4) = 2;
end  
if (springFlag(5) == 1) && (kry > 0)
    ebc(5) = 2;
end 
if (springFlag(6) == 1) && (krz > 0)
    ebc(6) = 2;
end

if (isnan(kx)) || (isnan(ky)) || (isnan(kz)) || (isnan(krx)) || (isnan(kry)) || (isnan(krz))
    msgbox('Invalid input data', 'Error','error');
    return
end  

if (kx > 0) || (ky > 0) || (kz > 0) || (krx > 0) || (kry > 0) || (krz > 0)
    springStiff = [kx, ky, kz, krx, kry, krz];
else
    springStiff = [];
end

% Initialize flag
nodalLoadsNeedToBeRedrawn = false;

for n = n_ID
    % Set load case of Node object
    if ~isempty(prescDispl)
        if isempty(nodes(n).nodalLoadCase)
            nodes(n).nodalLoadCase = zeros(12,lc);
        end
        nodes(n).nodalLoadCase(7:12,lc) = prescDispl';
    end

    % Check if new presc. displ. were set
    if isempty(nodes(n).prescDispl) && isempty(prescDispl)
    elseif (isempty(nodes(n).prescDispl) && ~isempty(prescDispl)) ||...
       (~isempty(nodes(n).prescDispl) && isempty(prescDispl))
        nodalLoadsNeedToBeRedrawn = true;
    elseif ~all((nodes(n).prescDispl == prescDispl) == true)
        nodalLoadsNeedToBeRedrawn = true;
    end

    % Get number of supports added to node and update information panel
    for i = 1:6
        if nodes(n).ebc(i) ~= 0 && ebc(i) == 0
            countNewFree = countNewFree + 1;
        elseif nodes(n).ebc(i) ~= 1 && ebc(i) == 1
            countNewFixed = countNewFixed + 1;
        elseif nodes(n).ebc(i) ~= 2 && ebc(i) == 2
            countNewSpring = countNewSpring + 1;
        end    
        if nodes(n).ebc(i) == 0 && ebc(i) ~= 0
            countRemovedFree = countRemovedFree + 1;
        elseif nodes(n).ebc(i) == 1 && ebc(i) ~= 1
            countRemovedFixed = countRemovedFixed + 1;
        elseif nodes(n).ebc(i) == 2 && ebc(i) ~= 2
            countRemovedSpring = countRemovedSpring + 1;    
        end
    end
    
    % Set Node object support conditions and presc. displ.
    nodes(n).ebc = ebc;
    nodes(n).prescDispl = prescDispl;
    nodes(n).springStiff = springStiff;
end

% Update uitable data (on GUI_Main)
infoPanelData = get(mdata.uitable_infoPanel,'Data');
nfreedof = cell2mat(infoPanelData(6,2)) + countNewFree - countRemovedFree;
nfixeddof = cell2mat(infoPanelData(7,2)) + countNewFixed - countRemovedFixed;
nspringdof = cell2mat(infoPanelData(8,2)) + countNewSpring - countRemovedSpring;
infoPanelData(6,:) = {'Free DOFs',nfreedof};
infoPanelData(7,:) = {'Fixed DOFs',nfixeddof};
infoPanelData(8,:) = {'Springs',nspringdof};
set(mdata.uitable_infoPanel,'Data',infoPanelData)

% Update mouse property
mouse = getappdata(0,'mouse');
if ~isempty(mouse.originalData)
    mouse.originalData = infoPanelData;
end
setappdata(0,'mouse',mouse)

% Set Drv object properties
drv.nodes = nodes;

% Enable "Process Data" button in main GUI
mdata = guidata(findobj('Tag','GUI_Main'));
set(mdata.pushbutton_ProcessData,'Enable','on');

% Disable model type option
set(mdata.popupmenu_Anm,'Enable','off');

% Disable result buttons
allLoadsNeedToBeRedrawn = false; % Initialize flag
if get(mdata.popupmenu_Results,'value') ~= 1
    allLoadsNeedToBeRedrawn = true;
end
set(mdata.popupmenu_Results,'Enable','off','value',1);
set(mdata.pushbutton_Textual,'Enable','off');
set(mdata.popupmenu_ElementResults,'Enable','off','value',1);
set(mdata.edit_Scale,'enable','off','visible','off');

% Disable/Enable visualization options
set(mdata.checkbox_Reactions,'Enable','off', 'Value', 0);

% Return variables to root
setappdata(0,'resultType',0);
setappdata(0,'nodes',nodes);
setappdata(0,'drv',drv);

% Make GUI a normal window
gui = findobj('Tag','GUI_Supports');
set(gui,'WindowStyle','normal');

% Draw updated model
redraw(mdata,'Nodes',false)
if allLoadsNeedToBeRedrawn == true
    redraw(mdata,'Loads')
elseif nodalLoadsNeedToBeRedrawn == true
    redraw(mdata,'Nodal Loads')
end

% Make GUI a modal window
set(gui,'WindowStyle','modal');

% Enable button for futre use
set(hObject,'enable','on')

%--------------------------------------------------------------------------
% Executes during object creation, after setting all properties.
function edit_Dx_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

mdata = guidata(findobj('Tag','GUI_Main'));
anm = get(mdata.popupmenu_Anm,'Value');
if anm == 3
    set(hObject,'Enable','off');
end

function edit_Dx_Callback(hObject, eventdata, handles)

%--------------------------------------------------------------------------
% Executes during object creation, after setting all properties.
function edit_Dy_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

mdata = guidata(findobj('Tag','GUI_Main'));
anm = get(mdata.popupmenu_Anm,'Value');
if anm == 3
    set(hObject,'Enable','off','String','0');
end

function edit_Dy_Callback(hObject, eventdata, handles)

%--------------------------------------------------------------------------
% Executes during object creation, after setting all properties.
function edit_Dz_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

mdata = guidata(findobj('Tag','GUI_Main'));
anm = get(mdata.popupmenu_Anm,'Value');
if (anm == 1) || (anm == 2)
    set(hObject,'Enable','off','String','0');
end

function edit_Dz_Callback(hObject, eventdata, handles)

%--------------------------------------------------------------------------
% Executes during object creation, after setting all properties.
function edit_Rx_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

mdata = guidata(findobj('Tag','GUI_Main'));
anm = get(mdata.popupmenu_Anm,'Value');
if (anm == 1) || (anm == 2) || (anm == 4)
    set(hObject,'Enable','off','String','0');
end

function edit_Rx_Callback(hObject, eventdata, handles)

%--------------------------------------------------------------------------
% Executes during object creation, after setting all properties.
function edit_Ry_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

mdata = guidata(findobj('Tag','GUI_Main'));
anm = get(mdata.popupmenu_Anm,'Value');
if (anm == 1) || (anm == 2) || (anm == 4)
    set(hObject,'Enable','off','String','0');
end

function edit_Ry_Callback(hObject, eventdata, handles)

%--------------------------------------------------------------------------
% Executes during object creation, after setting all properties.
function edit_Rz_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

mdata = guidata(findobj('Tag','GUI_Main'));
anm = get(mdata.popupmenu_Anm,'Value');
if (anm == 1) || (anm == 3) || (anm == 4)
    set(hObject,'Enable','off','String','0');
end

function edit_Rz_Callback(hObject, eventdata, handles)

%--------------------------------------------------------------------------
% Executes on button press in checkbox_Dx.
function checkbox_Dx_Callback(hObject, eventdata, handles)
nodes = getappdata(0,'nodes');

if get(hObject,'Value') == 1
    set(handles.edit_Dx,'Enable','on');
    set(handles.checkbox_Kx,'Value',0);
    set(handles.edit_Kx,'Enable','off','String','0');
else
    set(handles.edit_Dx,'Enable','off','String','0');
    for n = 1:size(nodes,1)
        if ~isempty(nodes(n).nodalLoadCase)
            nodes(n).nodalLoadCase(7,:) = 0;
        end
    end    
end

setappdata(0,'nodes',nodes);

%--------------------------------------------------------------------------
% Executes on button press in checkbox_Dy.
function checkbox_Dy_Callback(hObject, eventdata, handles)
nodes = getappdata(0,'nodes');

if get(hObject,'Value') == 1
    set(handles.edit_Dy,'Enable','on');
    set(handles.checkbox_Ky,'Value',0);
    set(handles.edit_Ky,'Enable','off','String','0');
else
    set(handles.edit_Dy,'Enable','off','String','0');
    for n = 1:size(nodes,1)
       if ~isempty(nodes(n).nodalLoadCase)
            nodes(n).nodalLoadCase(8,:) = 0;
       end
    end
end

setappdata(0,'nodes',nodes);

%--------------------------------------------------------------------------
% Executes on button press in checkbox_Dz.
function checkbox_Dz_Callback(hObject, eventdata, handles)
nodes = getappdata(0,'nodes');

if get(hObject,'Value') == 1
    set(handles.edit_Dz,'Enable','on');
    set(handles.checkbox_Kz,'Value',0);
    set(handles.edit_Kz,'Enable','off','String','0');
else
    set(handles.edit_Dz,'Enable','off','String','0');
     for n = 1:size(nodes,1)
       if ~isempty(nodes(n).nodalLoadCase)
            nodes(n).nodalLoadCase(9,:) = 0;
       end
    end
end

setappdata(0,'nodes',nodes);

%--------------------------------------------------------------------------
% Executes on button press in checkbox_Rx.
function checkbox_Rx_Callback(hObject, eventdata, handles)
mdata = guidata(findobj('Tag','GUI_Main'));
anm = get(mdata.popupmenu_Anm,'Value');
nodes = getappdata(0,'nodes');

if anm == 3
    set(handles.checkbox_Ry,'Value',get(hObject,'Value'));
    if get(hObject,'Value') == 1
        set(handles.edit_Rx,'Enable','on');
        set(handles.edit_Ry,'Enable','on');
        set(handles.checkbox_Krx,'Value',0);
        set(handles.checkbox_Kry,'Value',0);
        set(handles.edit_Krx,'Enable','off','String','0');
        set(handles.edit_Kry,'Enable','off','String','0');
    else
        set(handles.edit_Rx,'Enable','off','String','0');
        set(handles.edit_Ry,'Enable','off','String','0');
        for n = 1:size(nodes,1)
           if ~isempty(nodes(n).nodalLoadCase)
                nodes(n).nodalLoadCase(10,:) = 0;
                nodes(n).nodalLoadCase(11,:) = 0;
           end
        end
    end
elseif anm == 5
    set(handles.checkbox_Ry,'Value',get(hObject,'Value'));
    set(handles.checkbox_Rz,'Value',get(hObject,'Value'));
    if get(hObject,'Value') == 1
        set(handles.edit_Rx,'Enable','on');
        set(handles.edit_Ry,'Enable','on');
        set(handles.edit_Rz,'Enable','on');
        set(handles.checkbox_Krx,'Value',0);
        set(handles.checkbox_Kry,'Value',0);
        set(handles.checkbox_Krz,'Value',0);
        set(handles.edit_Krx,'Enable','off','String','0');
        set(handles.edit_Kry,'Enable','off','String','0');
        set(handles.edit_Krz,'Enable','off','String','0');
    else
        set(handles.edit_Rx,'Enable','off','String','0');
        set(handles.edit_Ry,'Enable','off','String','0');
        set(handles.edit_Rz,'Enable','off','String','0');
        for n = 1:size(nodes,1)
           if ~isempty(nodes(n).nodalLoadCase)
                nodes(n).nodalLoadCase(10,:) = 0; 
                nodes(n).nodalLoadCase(11,:) = 0; 
                nodes(n).nodalLoadCase(12,:) = 0; 
           end
        end
    end
end

setappdata(0,'nodes',nodes);

%--------------------------------------------------------------------------
% Executes on button press in checkbox_Ry.
function checkbox_Ry_Callback(hObject, eventdata, handles)
mdata = guidata(findobj('Tag','GUI_Main'));
anm = get(mdata.popupmenu_Anm,'Value');
nodes = getappdata(0,'nodes');

if anm == 3
    set(handles.checkbox_Rx,'Value',get(hObject,'Value'));
    if get(hObject,'Value') == 1
        set(handles.edit_Rx,'Enable','on');
        set(handles.edit_Ry,'Enable','on');
        set(handles.checkbox_Krx,'Value',0);
        set(handles.checkbox_Kry,'Value',0);
        set(handles.edit_Krx,'Enable','off','String','0');
        set(handles.edit_Kry,'Enable','off','String','0');
    else
        set(handles.edit_Rx,'Enable','off','String','0');
        set(handles.edit_Ry,'Enable','off','String','0');
        for n = 1:size(nodes,1)
           if ~isempty(nodes(n).nodalLoadCase)
                nodes(n).nodalLoadCase(10,:) = 0;
                nodes(n).nodalLoadCase(11,:) = 0;
           end
        end
    end
elseif anm == 5
    set(handles.checkbox_Rx,'Value',get(hObject,'Value'));
    set(handles.checkbox_Rz,'Value',get(hObject,'Value'));
    if get(hObject,'Value') == 1
        set(handles.edit_Rx,'Enable','on');
        set(handles.edit_Ry,'Enable','on');
        set(handles.edit_Rz,'Enable','on');
        set(handles.checkbox_Krx,'Value',0);
        set(handles.checkbox_Kry,'Value',0);
        set(handles.checkbox_Krz,'Value',0);
        set(handles.edit_Krx,'Enable','off','String','0');
        set(handles.edit_Kry,'Enable','off','String','0');
        set(handles.edit_Krz,'Enable','off','String','0');
    else
        set(handles.edit_Rx,'Enable','off','String','0');
        set(handles.edit_Ry,'Enable','off','String','0');
        set(handles.edit_Rz,'Enable','off','String','0');
        for n = 1:size(nodes,1)
           if ~isempty(nodes(n).nodalLoadCase)
                nodes(n).nodalLoadCase(10,:) = 0;
                nodes(n).nodalLoadCase(11,:) = 0;
                nodes(n).nodalLoadCase(12,:) = 0;
           end
        end
    end
end

setappdata(0,'nodes',nodes);

%--------------------------------------------------------------------------
% Executes on button press in checkbox_Rz.
function checkbox_Rz_Callback(hObject, eventdata, handles)
mdata = guidata(findobj('Tag','GUI_Main'));
anm = get(mdata.popupmenu_Anm,'Value');
nodes = getappdata(0,'nodes');

if anm == 2
    if get(hObject,'Value') == 1
        set(handles.edit_Rz,'Enable','on');
        set(handles.checkbox_Krz,'Value',0);
        set(handles.edit_Krz,'Enable','off','String','0');
    else
        set(handles.edit_Rz,'Enable','off','String','0');
        for n = 1:size(nodes,1)
           if ~isempty(nodes(n).nodalLoadCase)
                nodes(n).nodalLoadCase(12,:) = 0;
           end
        end
    end
elseif anm == 5
    set(handles.checkbox_Rx,'Value',get(hObject,'Value'));
    set(handles.checkbox_Ry,'Value',get(hObject,'Value'));
    if get(hObject,'Value') == 1
        set(handles.edit_Rx,'Enable','on');
        set(handles.edit_Ry,'Enable','on');
        set(handles.edit_Rz,'Enable','on');
        set(handles.checkbox_Krx,'Value',0);
        set(handles.checkbox_Kry,'Value',0);
        set(handles.checkbox_Krz,'Value',0);
        set(handles.edit_Krx,'Enable','off','String','0');
        set(handles.edit_Kry,'Enable','off','String','0');
        set(handles.edit_Krz,'Enable','off','String','0');
    else
        set(handles.edit_Rx,'Enable','off','String','0');
        set(handles.edit_Ry,'Enable','off','String','0');
        set(handles.edit_Rz,'Enable','off','String','0');
        for n = 1:size(nodes,1)
           if ~isempty(nodes(n).nodalLoadCase)
                nodes(n).nodalLoadCase(10,:) = 0;
                nodes(n).nodalLoadCase(11,:) = 0;
                nodes(n).nodalLoadCase(12,:) = 0;
           end
        end
    end
end

setappdata(0,'nodes',nodes);


function edit_Kx_Callback(hObject, eventdata, handles)


% --- Executes during object creation, after setting all properties.
function edit_Kx_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

mdata = guidata(findobj('Tag','GUI_Main'));
anm = get(mdata.popupmenu_Anm,'Value');
if anm == 3
    set(hObject,'Enable','off','String','0');
end


function edit_Ky_Callback(hObject, eventdata, handles)


% --- Executes during object creation, after setting all properties.
function edit_Ky_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

mdata = guidata(findobj('Tag','GUI_Main'));
anm = get(mdata.popupmenu_Anm,'Value');
if anm == 3
    set(hObject,'Enable','off','String','0');
end


function edit_Kz_Callback(hObject, eventdata, handles)


% --- Executes during object creation, after setting all properties.
function edit_Kz_CreateFcn(hObject, eventdata, handles)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

mdata = guidata(findobj('Tag','GUI_Main'));
anm = get(mdata.popupmenu_Anm,'Value');
if (anm == 1) || (anm == 2)
    set(hObject,'Enable','off','String','0');
end


function edit_Krx_Callback(hObject, eventdata, handles)
mdata = guidata(findobj('Tag','GUI_Main'));
anm = get(mdata.popupmenu_Anm,'Value');

set(handles.edit_Kry,'String',get(hObject,'String'));
if anm == 5
    set(handles.edit_Krz,'String',get(hObject,'String'));
end    


% --- Executes during object creation, after setting all properties.
function edit_Krx_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

mdata = guidata(findobj('Tag','GUI_Main'));
anm = get(mdata.popupmenu_Anm,'Value');
if (anm == 1) || (anm == 2) || (anm == 4)
    set(hObject,'Enable','off','String','0');
end


function edit_Kry_Callback(hObject, eventdata, handles)
mdata = guidata(findobj('Tag','GUI_Main'));
anm = get(mdata.popupmenu_Anm,'Value');

set(handles.edit_Krx,'String',get(hObject,'String'));
if anm == 5
    set(handles.edit_Krz,'String',get(hObject,'String'));
end    

% --- Executes during object creation, after setting all properties.
function edit_Kry_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

mdata = guidata(findobj('Tag','GUI_Main'));
anm = get(mdata.popupmenu_Anm,'Value');
if (anm == 1) || (anm == 2) || (anm == 4)
    set(hObject,'Enable','off','String','0');
end


function edit_Krz_Callback(hObject, eventdata, handles)
mdata = guidata(findobj('Tag','GUI_Main'));
anm = get(mdata.popupmenu_Anm,'Value');

if anm == 5
    set(handles.edit_Krx,'String',get(hObject,'String'));
    set(handles.edit_Kry,'String',get(hObject,'String'));
end    

% --- Executes during object creation, after setting all properties.
function edit_Krz_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

mdata = guidata(findobj('Tag','GUI_Main'));
anm = get(mdata.popupmenu_Anm,'Value');
if (anm == 1) || (anm == 3) || (anm == 4)
    set(hObject,'Enable','off','String','0');
end


% --- Executes on button press in checkbox_Kx.
function checkbox_Kx_Callback(hObject, eventdata, handles)
if get(hObject,'Value') == 1
    set(handles.edit_Kx,'Enable','on');
    set(handles.checkbox_Dx,'Value',0);
    set(handles.edit_Dx,'Enable','off','String','0');
else
    set(handles.edit_Kx,'Enable','off','String','0');
end


% --- Executes on button press in checkbox_Ky.
function checkbox_Ky_Callback(hObject, eventdata, handles)
if get(hObject,'Value') == 1
    set(handles.edit_Ky,'Enable','on');
    set(handles.checkbox_Dy,'Value',0);
    set(handles.edit_Dy,'Enable','off','String','0');
else
    set(handles.edit_Ky,'Enable','off','String','0');
end



% --- Executes on button press in checkbox_Kz.
function checkbox_Kz_Callback(hObject, eventdata, handles)
if get(hObject,'Value') == 1
    set(handles.edit_Kz,'Enable','on');
    set(handles.checkbox_Dz,'Value',0);
    set(handles.edit_Dz,'Enable','off','String','0');
else
    set(handles.edit_Kz,'Enable','off','String','0');
end



% --- Executes on button press in checkbox_Krx.
function checkbox_Krx_Callback(hObject, eventdata, handles)
mdata = guidata(findobj('Tag','GUI_Main'));
anm = get(mdata.popupmenu_Anm,'Value');

if anm == 3
    set(handles.checkbox_Kry,'Value',get(hObject,'Value'));
    if get(hObject,'Value') == 1
        set(handles.edit_Krx,'Enable','on');
        set(handles.edit_Kry,'Enable','on');
        set(handles.checkbox_Rx,'Value',0);
        set(handles.checkbox_Ry,'Value',0);
        set(handles.edit_Rx,'Enable','off','String','0');
        set(handles.edit_Ry,'Enable','off','String','0');
    else
        set(handles.edit_Krx,'Enable','off','String','0');
        set(handles.edit_Kry,'Enable','off','String','0');
    end
elseif anm == 5
    set(handles.checkbox_Kry,'Value',get(hObject,'Value'));
    set(handles.checkbox_Krz,'Value',get(hObject,'Value'));
    if get(hObject,'Value') == 1
        set(handles.edit_Krx,'Enable','on');
        set(handles.edit_Kry,'Enable','on');
        set(handles.edit_Krz,'Enable','on');
        set(handles.checkbox_Rx,'Value',0);
        set(handles.checkbox_Ry,'Value',0);
        set(handles.checkbox_Rz,'Value',0);
        set(handles.edit_Rx,'Enable','off','String','0');
        set(handles.edit_Ry,'Enable','off','String','0');
        set(handles.edit_Rz,'Enable','off','String','0');
    else
        set(handles.edit_Krx,'Enable','off','String','0');
        set(handles.edit_Kry,'Enable','off','String','0');
        set(handles.edit_Krz,'Enable','off','String','0');
    end
end


% --- Executes on button press in checkbox_Kry.
function checkbox_Kry_Callback(hObject, eventdata, handles)
mdata = guidata(findobj('Tag','GUI_Main'));
anm = get(mdata.popupmenu_Anm,'Value');

if anm == 3
    set(handles.checkbox_Krx,'Value',get(hObject,'Value'));
    if get(hObject,'Value') == 1
        set(handles.edit_Krx,'Enable','on');
        set(handles.edit_Kry,'Enable','on');
        set(handles.checkbox_Rx,'Value',0);
        set(handles.checkbox_Ry,'Value',0);
        set(handles.edit_Rx,'Enable','off','String','0');
        set(handles.edit_Ry,'Enable','off','String','0');
    else
        set(handles.edit_Krx,'Enable','off','String','0');
        set(handles.edit_Kry,'Enable','off','String','0');
    end
elseif anm == 5
    set(handles.checkbox_Krx,'Value',get(hObject,'Value'));
    set(handles.checkbox_Krz,'Value',get(hObject,'Value'));
    if get(hObject,'Value') == 1
        set(handles.edit_Krx,'Enable','on');
        set(handles.edit_Kry,'Enable','on');
        set(handles.edit_Krz,'Enable','on');
        set(handles.checkbox_Rx,'Value',0);
        set(handles.checkbox_Ry,'Value',0);
        set(handles.checkbox_Rz,'Value',0);
        set(handles.edit_Rx,'Enable','off','String','0');
        set(handles.edit_Ry,'Enable','off','String','0');
        set(handles.edit_Rz,'Enable','off','String','0');
    else
        set(handles.edit_Krx,'Enable','off','String','0');
        set(handles.edit_Kry,'Enable','off','String','0');
        set(handles.edit_Krz,'Enable','off','String','0');
    end
end

% --- Executes on button press in checkbox_Krz.
function checkbox_Krz_Callback(hObject, eventdata, handles)
mdata = guidata(findobj('Tag','GUI_Main'));
anm = get(mdata.popupmenu_Anm,'Value');

if anm == 2
    if get(hObject,'Value') == 1
        set(handles.edit_Krz,'Enable','on');
        set(handles.checkbox_Rz,'Value',0);
        set(handles.edit_Rz,'Enable','off');
    else
        set(handles.edit_Krz,'Enable','off','String','0');
    end
elseif anm == 5
    set(handles.checkbox_Krx,'Value',get(hObject,'Value'));
    set(handles.checkbox_Kry,'Value',get(hObject,'Value'));
    if get(hObject,'Value') == 1
        set(handles.edit_Krx,'Enable','on');
        set(handles.edit_Kry,'Enable','on');
        set(handles.edit_Krz,'Enable','on');
        set(handles.checkbox_Rx,'Value',0);
        set(handles.checkbox_Ry,'Value',0);
        set(handles.checkbox_Rz,'Value',0);
        set(handles.edit_Rx,'Enable','off','String','0');
        set(handles.edit_Ry,'Enable','off','String','0');
        set(handles.edit_Rz,'Enable','off','String','0');
    else
        set(handles.edit_Krx,'Enable','off','String','0');
        set(handles.edit_Kry,'Enable','off','String','0');
        set(handles.edit_Krz,'Enable','off','String','0');
    end
end

%--------------------------------------------------------------------------
function checkbox_MultiNodes_Callback(hObject, eventdata, handles)
if get(hObject,'value')
    set(handles.popupmenu_Node,'enable','off','string',' ','value',1)
    set(handles.edit_MultiNodes,'enable','on','string','')
else
    set(handles.popupmenu_Node,'enable','on','string',num2str(1:getappdata(0,'nnp'),'%d\n'),'value',1)
    popupmenu_Node_Callback(handles.popupmenu_Node, eventdata, handles)
    set(handles.edit_MultiNodes,'enable','off','string','')
end

%--------------------------------------------------------------------------
% Auxiliary function
% Reads string to get numbers or vectors
% Input:
% * str -> string to be read
% * max -> maximum value to be read (pre-dimensions output)
% Output:
% * flag -> flag for erros (0 = error; 1 = success)
% * output -> vector of integer numbers read from string
function [flag,output] = readStr(str,max)
output = zeros(1,max);
count = 0;           % counter for output index
numFlag = false;     % flag for number being read
vctrFlag = false;    % flag for vector being read
errorFlag = false;   % flag for errors on string input

for aux = 1:size(str,2)
    if strcmp(str(aux),' ')
        numFlag = false;
    elseif ~numFlag
        if ~isnan(str2double(str(aux)))
            numFlag = true;
            count = count + 1;
            output(count) = str2double(str(aux));
            if vctrFlag && aux == size(str,2)
                vctr = linspace(output(count-1),output(count),abs(output(count)-output(count-1))+1);
                if ~all(vctr <= max)
                    errorFlag = true;
                    break
                end
                output(count-1:count-2+size(vctr,2)) = vctr;
            end
        else
            errorFlag = true;
            break
        end
    elseif numFlag
        if ~isnan(str2double(str(aux)))
            numFlag = true;
            output(count) = output(count)*10 + str2double(str(aux));
            if vctrFlag && aux == size(str,2)
                vctr = linspace(output(count-1),output(count),abs(output(count)-output(count-1))+1);
                if ~all(vctr <= max)
                    errorFlag = true;
                    break
                end
                output(count-1:count-2+size(vctr,2)) = vctr;
            end
        elseif strcmp(str(aux),';')
            numFlag = false;
            if vctrFlag
                vctr = linspace(output(count-1),output(count),abs(output(count)-output(count-1))+1);
                if ~all(vctr <= max)
                    errorFlag = true;
                    break
                end
                output(count-1:count-2+size(vctr,2)) = vctr;
                count = count-1+size(vctr,2);
                vctrFlag = false;
            end
        elseif strcmp(str(aux),'-')
            if vctrFlag || aux == size(str,2)
                errorFlag = true;
                break
            end
            numFlag = false;
            vctrFlag = true;
        else
            errorFlag = true;
            break
        end
    end
end
output = nonzeros(output)';

if errorFlag || ~all(output <= max) || isempty(output)
    flag = false;
    output = [];
else
    flag = true;
end
