%% Edit Load Case Dialog Callback Functions
% This file contains the callback functions associated with the edit load
% cases dialog of the graphical version of the LESM program.
% Common input arguments for all callback functions:
%  hObject: handle to interface object related to the function
%  eventdata: reserved - to be defined in a future version of MATLAB
%  handles: structure with handles and user data
%
%% Authors
% Luiz Fernando Martha, Rafael Lopez Rangel and Pedro Cortez Lopes
%
%% ------------------------------------------------------------------------
% GUI initialization function.
function varargout = GUI_EditLoadCase(varargin)
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @GUI_EditLoadCase_OpeningFcn, ...
                   'gui_OutputFcn',  @GUI_EditLoadCase_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end

%--------------------------------------------------------------------------
% Executes just before GUI_EditLoadCase is made visible.
% Sets GUI initial properties.
function GUI_EditLoadCase_OpeningFcn(hObject, eventdata, handles, varargin) %#ok<INUSL>
% Choose default command line output for GUI_EditLoadCase
handles.output = hObject;

% Move GUI to the center of the screen
if getappdata(0,'move') == 1
    movegui(hObject,'center')
end

% Make GUI a modal window
set(hObject,'WindowStyle','modal');

% Get drv object
drv = getappdata(0,'drv');
  
% Create a list of load cases
lc = drv.strLc;
if ~isempty(lc)
    set(handles.listbox_LoadCase,'string',lc,'Value',1,'Max',size(lc,1))
end    

% Enable/Disable delete load case button
nlc = drv.nlc;
if nlc >= 2
    set(handles.pushbutton_Delete,'Enable','on')
else
    set(handles.pushbutton_Delete,'Enable','off')
end    

% Create a list of combinations
combs = drv.strComb;
if ~isempty(combs)
    set(handles.listbox_Combinations,'string',combs,'Value',1,'Max',size(combs,1))
end    

% Enable/Disable delete combinations pushbutton, listbox and uitable
ncomb = drv.ncomb;
if ncomb >= 1
    set(handles.pushbutton_DeleteComb,'Enable','on')
    set(handles.listbox_Combinations,'Enable','on')
    set(handles.uitable_Combinations,'Enable','on')
else
    set(handles.pushbutton_DeleteComb,'Enable','off')
    set(handles.listbox_Combinations,'Enable','off')
    set(handles.uitable_Combinations,'Enable','off')
end

% Set callback for cell edition in uitable_Combinations
set(handles.uitable_Combinations,'CellEditCallback',@uitable_Combinations_CellEditCallback)

% Write first combination's info on uitable
if ncomb >= 1
    loadComb = drv.loadComb(:,1);
    set(handles.listbox_Combinations,'Value',1)
    count = 0;
    for i = 1:size(loadComb,1)
        if drv.loadCombID(i,1) ~= 0
            count = count + 1;
            nextData = {char(lc(i)),loadComb(i)};
            if count == 1
                set(handles.uitable_Combinations,'Data',nextData);
            else
                tableData = get(handles.uitable_Combinations,'Data');
                tableData(size(tableData,1)+1,:) = nextData;
                set(handles.uitable_Combinations,'Data',tableData);
            end
        end
    end  
else
    set(handles.uitable_Combinations,'Enable','off','Data',{})
end

% Update handles structure
guidata(hObject, handles);

%--------------------------------------------------------------------------
% --- Outputs from this function are returned to the command line.
function varargout = GUI_EditLoadCase_OutputFcn(~, ~, handles) 
varargout{1} = handles.output;

%--------------------------------------------------------------------------
% --- Executes on button press in pushbutton_New.
function pushbutton_New_Callback(~, ~, handles) %#ok<DEFNU>
drv = getappdata(0,'drv');
nlc = drv.nlc;
lc = drv.strLc;
newLoadCase = char(inputdlg('Enter new load case name','New Load Case',[1 50]));

if ~isempty(newLoadCase)
    % Check if chosen name is already in use, or is empty
    if strcmp(newLoadCase,get(handles.listbox_LoadCase,'String')) == 1
        msgbox('There is already a load case with this name, please choose another name.', 'Error','error');
        return
    elseif strcmp(newLoadCase,' ')
        return
    elseif strcmp(newLoadCase,'  ')
        return
    elseif strcmp(newLoadCase,'   ')
        return
    elseif strcmp(newLoadCase,'    ')
        return
    elseif strcmp(newLoadCase,'     ')
        return
    elseif strcmp(newLoadCase,'      ')
        return
    end
    
    for i = 1:size(lc,1)
        if strcmp(newLoadCase,lc(i)) == 1
            msgbox('There is already a load case with this name, please choose another name.', 'Error','error');
            return  
        end    
    end
    
    % Write new load case name on listbox and update drv object
    lc = char(lc);
    set(handles.listbox_LoadCase,'string',{lc,newLoadCase},'Max',get(handles.listbox_LoadCase,'Max')+1)
    set(handles.pushbutton_Delete,'Enable','on')
    drv.nlc = nlc + 1;
    drv.strLc = get(handles.listbox_LoadCase,'string');
    
    % Write new load case in the popupmenu (GUI_Main) and update drv.loadComb
    ncomb = drv.ncomb;
    comb = drv.strComb;
    mdata = guidata(findobj('Tag','GUI_Main'));
    currentLc = get(mdata.popupmenu_LoadCase,'Value');
    if ncomb == 0
        set(mdata.popupmenu_LoadCase,'String',get(handles.listbox_LoadCase,'String'),...
            'Max',get(handles.listbox_LoadCase,'Max'));
    else
        if currentLc <= nlc
            set(mdata.popupmenu_LoadCase,'String',{char(get(handles.listbox_LoadCase,'String')),char(comb)},...
               'Max',get(handles.listbox_LoadCase,'Max')+ncomb);
        else
            set(mdata.popupmenu_LoadCase,'String',{char(get(handles.listbox_LoadCase,'String')),char(comb)},...
               'Max',get(handles.listbox_LoadCase,'Max')+ncomb,'Value',currentLc+1);
            setappdata(0,'currentLc',currentLc+1);
        end
        drv.loadComb(size(drv.loadComb,1)+1,:) = zeros(1,ncomb);
        drv.loadCombID(size(drv.loadCombID,1)+1,:) = zeros(1,ncomb);
    end
    
    % Save drv in root
    setappdata(0,'drv',drv)
end

%--------------------------------------------------------------------------
% --- Executes on button press in pushbutton_Delete.
function pushbutton_Delete_Callback(hObject, ~, handles) %#ok<DEFNU>
mdata = guidata(findobj('Tag','GUI_Main'));
nodes = getappdata(0,'nodes');
elems = getappdata(0,'elems');
drv = getappdata(0,'drv');
nlc = drv.nlc;
ncomb = drv.ncomb;
lc = drv.strLc;
combs = drv.strComb;

% Load cases to be deleted
delLc = get(handles.listbox_LoadCase,'Value');

% Check if all load cases are selected
if size(delLc,2) == size(lc,1)
    msgbox('Cannot delete all load cases.', 'Error','error');
    return
end

% Initialize redraw flag (info if the model needs to be redrawn in canvas)
redrawFlag = 0;

% Delete selected load cases from load case names vector
lc(delLc) = [];

% Set new value and max propeties in listbox_LoadCase
% (prevents MATLAB warnings)
if min(delLc) ~= 1
    value = min(delLc) - 1;
else
    value = min(delLc);
end
maxLc = get(handles.listbox_LoadCase,'Max');
set(handles.listbox_LoadCase,'string',lc,'Value',value,'Max',maxLc-size(delLc,2))

% Get current popupmenu value
currentVal = get(mdata.popupmenu_LoadCase,'Value');

% Delete selected load cases from popupmenu in GUI_Main
if ncomb == 0
    if all(delLc ~= currentVal) == 1 % none of the deleted load cases are the current one
        auxValue = 0;
        for i = 1:size(delLc,2)
            if delLc(i) < currentVal
                auxValue = auxValue + 1;
            end
        end
        set(mdata.popupmenu_LoadCase,'String',get(handles.listbox_LoadCase,'String'),'Max',maxLc-size(delLc,2),'Value',currentVal - auxValue);
    else % the current load case is among those being deleted
        set(mdata.popupmenu_LoadCase,'String',get(handles.listbox_LoadCase,'String'),'Max',maxLc-size(delLc,2),'Value',value);
        redrawFlag = 1;
    end
else % there are combinations
    if all(delLc ~= currentVal) == 1 && currentVal <= nlc  % none of the deleted load cases are the current one
        auxValue = 0;
        for i = 1:size(delLc,2)
            if delLc(i) < currentVal
                auxValue = auxValue + 1;
            end
        end
        set(mdata.popupmenu_LoadCase,'String',{char(get(handles.listbox_LoadCase,'String')),char(combs)},...
            'Max',maxLc-size(delLc,2)+ncomb,'Value',currentVal - auxValue);
    elseif all(delLc ~= currentVal) == 1 && currentVal > nlc % current load case is a combination
        set(mdata.popupmenu_LoadCase,'String',{char(get(handles.listbox_LoadCase,'String')),char(combs)},...
            'Max',maxLc-size(delLc,2)+ncomb,'Value',currentVal - size(delLc,2));
    elseif all(delLc ~= currentVal) == 0 % the current load case is among those being deleted
        set(mdata.popupmenu_LoadCase,'String',{char(get(handles.listbox_LoadCase,'String')),char(combs)},...
            'Max',maxLc-size(delLc,2)+ncomb,'Value',value);
        redrawFlag = 1;
    end    
end    

% Check if there is only one load case remaining. If so, disable delete
% load case pushbutton.
if get(handles.listbox_LoadCase,'Max') == 1
    set(hObject,'Enable','off')
end    

% Delete selected load cases from load case matrix in each node and elem
auxDelLc = fliplr(delLc);
for dlc = 1:size(delLc,2)  
    for n = 1:drv.nnp
        if auxDelLc(dlc) <= size(nodes(n).nodalLoadCase,2)
            nodes(n).nodalLoadCase(:,auxDelLc(dlc)) = [];
        end
    end

    for e = 1:drv.nel
        if auxDelLc(dlc) <= size(elems(e).load.elemLoadCase,2)
            elems(e).load.elemLoadCase(:,auxDelLc(dlc)) = [];
        end
    end   
end

% Delete selected load cases from loadComb matrix
if ncomb ~= 0
    drv.loadComb(delLc,:) = [];
    drv.loadCombID(delLc,:) = [];
end

% Delete load combinations that no longer have any load cases
nc = ncomb; % initialize auxiliary variables
delLComb = 0;

for i = 1:nc
    if all(drv.loadCombID(:,i) == 0) == 1 % if all terms in a column of drv.loadCombID are zero
        ncomb = ncomb - 1;                % all load cases of the respective combination have
        delLComb = delLComb + 1;          % been deleted.
        
        if get(handles.listbox_Combinations,'Value') == i % the now empty load comb is
            if i ~= 1                                     % the selected one.
                value = i -1;
            else
                value = i;
            end
        end
        
        % Update combinations listbox
        if ncomb ~= 0 % not all load combinations are empty
            strComb = get(handles.listbox_Combinations,'String');
            strComb(i,:) = []; % delete empty load comb name from string
            set(handles.listbox_Combinations,'String',char(strComb),'Max',ncomb,'Value',value)
            listbox_Combinations_Callback([], [], handles);
        else % all load combinations became empty (were deleted)
            set(handles.listbox_Combinations,'String',' ','Enable','off','Value',1,'Max',1)
            set(handles.pushbutton_DeleteComb,'Enable','off')
            data = {}; % clear uitable
            set(handles.uitable_Combinations,'Enable','off','Data',data)
        end
        
        % Update load cases popupmenu (GUI_Main)
        strPopupmenu = get(mdata.popupmenu_LoadCase,'String');
        strPopupmenu(nlc - size(delLc,2) + i,:) = []; % delete empty load comb name from string
        set(mdata.popupmenu_LoadCase,'String',char(strPopupmenu),'Max',nlc - size(delLc,2) + ncomb)
        
        % Check if deleted combination is the current load case
        if get(mdata.popupmenu_LoadCase,'Value') == i + nlc
            set(mdata.popupmenu_LoadCase,'Value',1)
            redrawFlag = 1;
        end    
    end
end

% Update uitable_Combinations
nlc = nlc - size(delLc,2);
strLc = get(handles.listbox_LoadCase,'string');
if ncomb ~= 0
    comb = get(handles.listbox_Combinations,'value');
    tableData = cell(nlc,2);
    count = 0;
    for i = 1:nlc
        if drv.loadCombID(i,comb) ~= 0
            count = count + 1;
            tableData(count,:) = {char(strLc(i,:)),drv.loadComb(i,comb)};
        else
            tableData(end,:) = [];
        end
    end
    if ~isempty(tableData)
        set(handles.uitable_Combinations,'Data',tableData);
    else
        set(handles.uitable_Combinations,'Data',{});
    end
end

% Delete empty load combs from drv.loadComb
indexDelComb = zeros(delLComb,1);
count = 0;
for j = 1:size(drv.loadComb,2)
    if all(drv.loadCombID(:,j) == 0) == 1
        count = count + 1;
        indexDelComb(count) = j;
    end
end
drv.loadComb(:,indexDelComb) = [];
drv.loadCombID(:,indexDelComb) = [];

% Check if model needs to be redrawn (current load case was deleted)
if redrawFlag == 1
    setappdata(0,'currentLc',0)
    GUI_Main('popupmenu_LoadCase_Callback',mdata.popupmenu_LoadCase, [], mdata)
end

% Update drv object
drv.nlc = nlc;
drv.strLc = strLc;
drv.ncomb = ncomb;
drv.strComb = get(handles.listbox_Combinations,'String');
drv.nodes = nodes;
drv.elems = elems;

% Save variables in root
setappdata(0','currentLc',get(mdata.popupmenu_LoadCase,'value'))
setappdata(0,'nodes',nodes)
setappdata(0,'elems',elems)
setappdata(0,'drv',drv)

%--------------------------------------------------------------------------
% --- Executes on selection change in listbox_LoadCase.
function listbox_LoadCase_Callback(~, ~, ~) %#ok<DEFNU>

%--------------------------------------------------------------------------
% --- Executes during object creation, after setting all properties.
function listbox_LoadCase_CreateFcn(hObject, ~, ~) %#ok<DEFNU>
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

%--------------------------------------------------------------------------
% --- Executes on button press in pushbutton_Combination.
function pushbutton_Combination_Callback(~, ~, handles) %#ok<DEFNU>
drv = getappdata(0,'drv');
ncomb = drv.ncomb;
combs = drv.strComb;
newComb = char(inputdlg('Enter new combination name','New Combination',[1 50]));

% Add combination
if ~isempty(newComb)
    % Check if chosen name is already in use, or is empty
    if strcmp(newComb,get(handles.listbox_Combinations,'String')) == 1
        msgbox('There is already a load case with this name, please choose another name.', 'Error','error');
        return
    elseif strcmp(newComb,' ')
        return
    elseif strcmp(newComb,'  ')
        return
    elseif strcmp(newComb,'   ')
        return
    elseif strcmp(newComb,'    ')
        return
    elseif strcmp(newComb,'     ')
        return
    elseif strcmp(newComb,'      ')
        return
    end
    
    for i = 1:size(combs,1)
        if strcmp(newComb,combs(i,:)) == 1
            msgbox('There is already a combination with this name, please choose another name.', 'Error','error');
            return  
        end    
    end
    
    % Write name on combinations listbox
    if ncomb == 0   % there were previously no combinations
        set(handles.listbox_Combinations,'Enable','on','String',newComb,'Max',1)
    else   % there was already at least one combination
        combs = char(combs);
        set(handles.listbox_Combinations,'Enable','on','String',{combs,newComb},'Max',get(handles.listbox_Combinations,'Max')+1)
    end
    ncomb = ncomb + 1;
    set(handles.listbox_Combinations,'Value',ncomb)
    
    % Enable delete pushbutton and uitable_Combinations
    set(handles.pushbutton_DeleteComb,'Enable','on')
    set(handles.uitable_Combinations,'Enable','on')
    
    % Write new comb info on uitable
    lc = (get(handles.listbox_LoadCase,'Value'))'; % selected load cases that form combination
    strLc = get(handles.listbox_LoadCase,'String'); 
    loadCases = strLc(lc,:);  % names of selected load cases
    combFactors = ones(size(loadCases,1),1);  % default comb factor = 1
    
    for i = 1:size(lc,1)
        if i == 1 % Set first line of uitable
            set(handles.uitable_Combinations,'Data',{char(loadCases(i,:)),combFactors(i)}) 
        else % set the other lines
            data = get(handles.uitable_Combinations,'Data');
            newData = {char(loadCases(i,:)),combFactors(i)};
            data(size(data,1)+1,:) = newData;
            set(handles.uitable_Combinations,'Data',data) 
        end    
    end 
    
    % Update drv.loadComb matrix
    nlc = drv.nlc;
    loadComb = zeros(nlc,1);
    loadComb(lc) = ones(size(lc,1),1);
    if isempty(drv.loadComb)
        drv.loadComb = zeros(nlc,ncomb); 
    end
    drv.loadComb(:,ncomb) = loadComb;
    
    % Update drv.loadCombID matrix
    if isempty(drv.loadCombID)
        drv.loadCombID = loadComb;
    else
        drv.loadCombID(:,ncomb) = loadComb;
    end
    
    % Update drv object
    drv.ncomb = ncomb;
    drv.strComb = get(handles.listbox_Combinations,'String');
    setappdata(0,'drv',drv)
    
    % Writes new comb name in the popupmenu (GUI_Main)
    mdata = guidata(findobj('Tag','GUI_Main'));
    str = char(get(mdata.popupmenu_LoadCase,'String'));
    set(mdata.popupmenu_LoadCase,'String',{str,newComb},'Max',get(handles.listbox_Combinations,'Max')+nlc)  
end

%--------------------------------------------------------------------------
% --- Executes on button press in pushbutton_DeleteComb.
function pushbutton_DeleteComb_Callback(hObject, ~, handles) %#ok<DEFNU>
mdata = guidata(findobj('Tag','GUI_Main'));
drv = getappdata(0,'drv');
nlc = drv.nlc;
lc = drv.strLc;
ncomb = drv.ncomb;
combs = drv.strComb;

% Initialize redraw flag (info if the model needs to be redrawn in canvas)
redrawFlag = 0;

% Load case combinations to be deleted
delLcomb = get(handles.listbox_Combinations,'Value');

% Delete selected combinations from combinations' names vector
combs(delLcomb,:) = [];

% Set new value property in listbox_Combinations (prevents MATLAB warnings)
if min(delLcomb) ~= 1
    value = min(delLcomb) - 1;
else
    value = min(delLcomb);
end

maxLcomb = get(handles.listbox_Combinations,'Max');
ncomb = ncomb - size(delLcomb,2);

% Check if all combinations were deleted
if ncomb == 0
    set(handles.listbox_Combinations,'Enable','off','string',' ','Value',1,'Max',1)
    set(hObject,'Enable','off') % disable delete combinations button
    drv.loadComb = []; % clean loadComb matrix
    drv.loadCombID = []; % clean loadCombID matrix
    set(handles.uitable_Combinations,'Enable','off','Data',{}) % clear uitable
    if get(mdata.popupmenu_LoadCase,'Value') > nlc % current load case is a combination
        set(mdata.popupmenu_LoadCase,'Value',1);
        redrawFlag = 1;
    end 
    set(mdata.popupmenu_LoadCase,'String',lc,'Max',nlc);
else  % there are combinations left
    set(handles.listbox_Combinations,'string',char(combs),'Value',value,'Max',maxLcomb-size(delLcomb,2))
    drv.loadComb(:,delLcomb) = []; % delete load combinations from loadComb matrix
    drv.loadCombID(:,delLcomb) = []; % delete load combinations from loadCombID matrix
    
    % Write selected combination info on the uitable
    count = 0;
    loadComb = drv.loadComb(:,value);
    for i = 1:size(loadComb,1)
        if drv.loadCombID(i,value) ~= 0
            count = count + 1;
            newData = {char(lc(i)),loadComb(i)};
            if count == 1  % first line of the uitable
                set(handles.uitable_Combinations,'Data',newData);
            else
                data = get(handles.uitable_Combinations,'Data');
                data(size(data,1)+1,:) = newData;
                set(handles.uitable_Combinations,'Data',data);
            end
        end
    end
    if get(mdata.popupmenu_LoadCase,'Value') > nlc % current load case is a combination
        set(mdata.popupmenu_LoadCase,'String',{char(lc),char(combs)},'Max',maxLcomb-size(delLcomb,2)+nlc,'Value',value + nlc);
        redrawFlag = 1;
    end
end    
 
% Draw and update model
if redrawFlag == 1
    setappdata(0,'currentLc',0)
    GUI_Main('popupmenu_LoadCase_Callback',mdata.popupmenu_LoadCase,[],mdata)
end

% Update drv object
drv.ncomb = ncomb;
drv.strComb = get(handles.listbox_Combinations,'String');

% Save variables in root
setappdata(0','currentLc',get(mdata.popupmenu_LoadCase,'value'))
setappdata(0,'drv',drv)

%--------------------------------------------------------------------------
% --- Executes on selection change in listbox_Combinations.
function listbox_Combinations_Callback(~, ~, handles)
vComb = get(handles.listbox_Combinations,'Value');
if size(vComb,2) >= 2 % if multiple combs, only consider the first one.
    vComb = vComb(1);
end
drv = getappdata(0,'drv');
lc = drv.strLc;
loadComb = drv.loadComb(:,vComb);

% Write selected combination info on the uitable
count = 0;
for i = 1:size(loadComb,1)
    if drv.loadCombID(i,vComb) ~= 0
        count = count + 1;
        newData = {char(lc(i)),loadComb(i)};
        if count == 1
            set(handles.uitable_Combinations,'Data',newData);
        else
            data = get(handles.uitable_Combinations,'Data');
            data(size(data,1)+1,:) = newData;
            set(handles.uitable_Combinations,'Data',data);
        end
    end
end

%--------------------------------------------------------------------------
% --- Executes during object creation, after setting all properties.
function listbox_Combinations_CreateFcn(hObject, ~, ~) %#ok<DEFNU>
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

%--------------------------------------------------------------------------
% Executes when cell is edited in uitable_Combinations
function uitable_Combinations_CellEditCallback(~,~,~)
mdata = guidata(findobj('tag','GUI_EditLoadCase'));
set(mdata.pushbutton_Apply,'Enable','on')

%--------------------------------------------------------------------------
% --- Executes on button press in pushbutton_Apply.
function pushbutton_Apply_Callback(hObject, eventdata, handles) %#ok<DEFNU>
% Get drv object
drv = getappdata(0,'drv');

% Get uitable data and selected load comb
tableData = get(handles.uitable_Combinations,'Data');
whichComb = get(handles.listbox_Combinations,'value');

% Set uitable data (user input) to drv (COMB FACTORS)
count = 0;
combFactorsChanged = false;
for i = 1:size(drv.loadComb,1)
    if drv.loadCombID(i,whichComb) ~= 0
        count = count + 1;
        if ~isnan(cell2mat(tableData(count,2)))
            if cell2mat(tableData(count,2)) ~= drv.loadComb(i,whichComb)
                drv.loadComb(i,whichComb) = cell2mat(tableData(count,2));
                combFactorsChanged = true;
            end
        end
    end
end

% Save drv in root
setappdata(0,'drv',drv)

% Update uitable
listbox_Combinations_Callback([], [], handles)

% Check if combination that changed is current load case
if combFactorsChanged == true
    mdata = guidata(findobj('tag','GUI_Main'));
    currentLc = get(mdata.popupmenu_LoadCase,'value');
    if currentLc == (whichComb + drv.nlc)
        setappdata(0,'currentLc',0)
        GUI_Main('popupmenu_LoadCase_Callback',mdata.popupmenu_LoadCase,eventdata,mdata)
    end
end

% Disable apply pushbutton
set(hObject,'enable','off')

%--------------------------------------------------------------------------
% --- Executes when user attempts to close GUI_EditLoadCase.
function GUI_EditLoadCase_CloseRequestFcn(hObject, ~, ~) %#ok<DEFNU>
delete(hObject);

%--------------------------------------------------------------------------
% --- Executes on key press with focus on GUI_EditLoadCase and none of its controls.
function GUI_EditLoadCase_KeyPressFcn(~,~,~) %#ok<DEFNU>
