from stack import Stack


class RPNcalc(Stack):
    def __init__(self):
        super(RPNcalc, self).__init__()

    def getOperands(self):
        if self.isEmpty():
            print("Empty stack!\n")
            return False, 0, 0

        n1 = self.pop()
        if self.isEmpty():
            print("Two operands needed!\n")
            self.push(n1)
            return False, 0, 0

        n2 = self.pop()
        return True, int(n1), int(n2)

    def enterNumber(self, _n):
        self.push(_n)

    def selectOp_sum(self):
        check, n1, n2 = self.getOperands()
        if not check:
            return
        self.push(n2 + n1)

    def selectOp_diff(self):
        check, n1, n2 = self.getOperands()
        if not check:
            return
        self.push(n2 - n1)

    def selectOp_prod(self):
        check, n1, n2 = self.getOperands()
        if not check:
            return
        self.push(n2 * n1)

    def selectOp_div(self):
        check, n1, n2 = self.getOperands()
        if not check:
            return
        if n1 != 0:
            self.push(int(n2 / n1))
        else:
            print("Error: division by zero!\n")
