from rpncalc import RPNcalc


class AppController:
    def __init__(self):
        self.rpn = RPNcalc()

    def pollingLoop(self):
        while True:
            print("Enter a number or an operator ('q' to quit): ")
            string = input()
            try:
                n = int(string)
                self.rpn.enterNumber(n)
            except BaseException:
                if string == 'q':
                    break
                elif string == '+':
                    self.rpn.selectOp_sum()
                elif string == '-':
                    self.rpn.selectOp_diff()
                elif string == '*':
                    self.rpn.selectOp_prod()
                elif string == '/':
                    self.rpn.selectOp_div()
                else:
                    print("Error: enter a valid operator!\n")
            print("\n-----------\n" + self.rpn.dump() + "-----------\n")
