package tecgraf.openbus.opendreams;

/**
 * A classe <code>TStamp</code> representa um time stamp unico no sistema.
 */
public class TStamp {
  private final int NCHARS = 9; /* Numero de caractres da string de tempo */
  /*
   * String de conversao <=> Base64 Encoding Table
   * 
   * Referencia: http://www.faqs.org/rfcs/rfc3548.html
   * 
   * The "URL and Filename safe" Base 64 Alphabet
   * 
   * Value Encoding Value Encoding Value Encoding Value Encoding 0 A 17 R 34 i
   * 51 z 1 B 18 S 35 j 52 0 2 C 19 T 36 k 53 1 3 D 20 U 37 l 54 2 4 E 21 V 38 m
   * 55 3 5 F 22 W 39 n 56 4 6 G 23 X 40 o 57 5 7 H 24 Y 41 p 58 6 8 I 25 Z 42 q
   * 59 7 9 J 26 a 43 r 60 8 10 K 27 b 44 s 61 9 11 L 28 c 45 t 62 - (minus) 12
   * M 29 d 46 u 63 _ (understrike) 13 N 30 e 47 v 14 O 31 f 48 w 15 P 32 g 49 x
   * 16 Q 33 h 50 y
   */
  private final String str_conv =
    "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_";

  private static Long lastStamp = 0l;

  private String uniq_id;
  private long tstamp;

  @Override
  public String toString() {
    return uniq_id;
  }

  public long toLong() {
    return tstamp;
  }

  public TStamp() {
    this.tstamp = System.currentTimeMillis();

    synchronized (lastStamp) {
      if (tstamp <= lastStamp) {
        tstamp = ++lastStamp;
      }
      lastStamp = tstamp;
    }
    this.uniq_id = "";
    /*
     * Cada caracter corresponde a 6 bits O primeiro caracter corresponde aos 6
     * bits mais significativos
     */
    long tempo_us = tstamp;
    for (int i = NCHARS - 1; i >= 0; i--) {
      /* 0x3F hex = 63 dec = 00111111 bin */
      uniq_id = str_conv.charAt((int) (tempo_us & 0x3F)) + uniq_id;
      tempo_us = tempo_us >> 6;
    }
  }

  public TStamp(String uniq_id) {
    /*
     * Zera o numero que contem o timestamp em usec
     */
    this.uniq_id = uniq_id;
    tstamp = 0;

    /*
     * Transforma da base64 p/ base10
     */
    for (int i = 0; i < NCHARS; i++) {
      tstamp = tstamp << 6;
      for (int j = 0; j <= 63; j++) {
        if (uniq_id.charAt(i) == str_conv.charAt(j)) {
          tstamp = tstamp + j;
          break;
        }
      }
    }
  }
}
