package tecgraf.openbus.opendreams;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

import tecgraf.openbus.DRMAA.FileTransferMode;
import tecgraf.openbus.DRMAA.JobSubmissionState;
import tecgraf.openbus.DRMAA.JobTemplateImpl;

/**
 * A classe <code>OpenDreamsJobTemplateImpl</code> implementa um
 * <code>OpenDreamsJobTemplate</code>.
 * 
 * Um job template do OpenDreams possui, alm dos atributos default do job
 * template, outros atributos que so especficos para execuo de algoritmos ou
 * fluxo de algoritmos no OpenDreams. Esses atributos adicionais so:
 * <ul>
 * <li>jobParameters: o conjunto de chave-valor que define os parmetros dos
 * algoritmos.
 * </ul>
 * 
 * @author Tecgraf PUC-Rio
 * 
 */
public class OpenDreamsJobTemplateImpl extends OpenDreamsJobTemplate {

  /** Mapa com os parmetros para execuo do job */
  protected HashMap<String, String> jobParametersMap;

  /**
   * Construtor.
   */
  public OpenDreamsJobTemplateImpl() {
    this.id = new TStamp().toLong();
    this.remoteCommand = "";
    this.args = new String[0];
    this.jobSubmissionState = JobSubmissionState.ACTIVE_STATE;
    this.jobEnvironment = new String[0][0];
    this.email = new String[0];
    this.blockEmail = false;
    this.transferFiles = new FileTransferMode(false, false, false);
    this.jobParameters = new String[0][0];
    this.jobParametersMap = new HashMap<String, String>();
    this.jobCategory = "CSBase";
  }

  @Override
  public boolean equals(Object o) {
    if (o == null) {
      return false;
    }
    if (!OpenDreamsJobTemplateImpl.class.isInstance(o)) {
      return false;
    }
    OpenDreamsJobTemplateImpl other = OpenDreamsJobTemplateImpl.class.cast(o);
    return this.id == other.id;
  }

  @Override
  public int hashCode() {
    return (int) id;
  }

  @Override
  public String[] attributeNames() {
    List<String> allAttributes =
      Arrays.asList(JobTemplateImpl.getAttributeNames());
    allAttributes.add("job_parameters");
    allAttributes.add("job_description");
    allAttributes.add("job_priority");
    return allAttributes.toArray(new String[0]);
  }
}
