package tecgraf.openbus.DRMAA;


/**
 * Implementao default do JobTemplate.
 * 
 * @author Tecgraf PUC-Rio
 *
 */
public class JobTemplateImpl extends JobTemplate {

  /**
   * Construtor padro sem argumentos, usado no unmarshalling.
   * Devido a sua existncia, o jacorb no precisa de uma fbrica separada 
   * para esse tipo. Esse  um recurso especfico do JacORB e no
   *  padronizado no Corba.
   */
  public JobTemplateImpl() {
    this.remoteCommand = "";
    this.args = new String[0];
    this.jobSubmissionState = JobSubmissionState.ACTIVE_STATE;
    this.transferFiles = new FileTransferMode(false,false,false);
  }

  @Override
  public String[] attributeNames() {
    return getAttributeNames();
  }
  
  /**
   * Obtm o nome dos atributos implementados no JobTemplate DRMAA.
   * @return o array com o nome dos atributos de um job template
   */
  public static String[] getAttributeNames() {
    return new String[] {
      "remote_command",
      "v_argv",
      "js_state",
      "v_env",
      "wd",
      "working_directory",
      "job_category",
      "native_specification",
      "v_email",
      "block_email",
      "start_time",
      "job_name",
      "input_path",
      "output_path",
      "error_path",
      "join_files",
      "transfer_files",
      "deadline_time",
      "wct_hlimit",
      "wct_slimit",
      "run_duration_hlimit",
      "run_duration_slimit"
    };
  }
}
