import opendreams.proxy.OpenDreamsException;
import opendreams.proxy.OpenDreamsProxy;
import opendreams.proxy.Project;
import tecgraf.openbus.DRMAA.AlreadyActiveSessionException;
import tecgraf.openbus.DRMAA.AuthorizationException;
import tecgraf.openbus.DRMAA.DefaultContactStringException;
import tecgraf.openbus.DRMAA.DeniedByDrmException;
import tecgraf.openbus.DRMAA.DrmCommunicationException;
import tecgraf.openbus.DRMAA.DrmsExitException;
import tecgraf.openbus.DRMAA.DrmsInitException;
import tecgraf.openbus.DRMAA.ExitTimeoutException;
import tecgraf.openbus.DRMAA.InternalException;
import tecgraf.openbus.DRMAA.InvalidArgumentException;
import tecgraf.openbus.DRMAA.InvalidContactStringException;
import tecgraf.openbus.DRMAA.InvalidJobException;
import tecgraf.openbus.DRMAA.InvalidJobTemplateException;
import tecgraf.openbus.DRMAA.NoActiveSessionException;
import tecgraf.openbus.DRMAA.NoDefaultContactStringSelectedException;
import tecgraf.openbus.DRMAA.OutOfMemoryException;
import tecgraf.openbus.DRMAA.Session;
import tecgraf.openbus.DRMAA.TryLaterException;
import tecgraf.openbus.opendreams.IOpenDreams;
import tecgraf.openbus.opendreams.OpenDreamsJobInfo;
import tecgraf.openbus.opendreams.OpenDreamsJobTemplate;

/**
 * Teste de acesso ao servio OpenDreams do OpenBus.
 * 
 * @author Tecgraf PUC-Rio
 * 
 */
public class SimpleDemoOpenDreams {
  /**
   * Executa o teste.
   * 
   * @param args argumentos da linha de comando. No possui argumentos de
   *        entrada.
   * @throws Exception se ocorrer alguma falha na execuo do teste
   */
  public static void main(String[] args) throws Exception {
    new SimpleDemoOpenDreams().run();
  }

  private void run() {
    OpenDreamsProxy opendreamsProxy = null;
    try {
      /* Constroi o proxy usando as propriedades do arquivo default */
      opendreamsProxy = new OpenDreamsProxy();
      /*
       * As chamadas aos mtodos a seguir, setPrivatekey e setACSCertificate,
       * so opcionais. Quando chamados, o proxy ignora os valores das
       * propriedades openbus.acs.private.key e openbus.acs.certificate e usa os
       * streams passados como parmetros nas chamadas. So especialmente teis
       * quando os arquivos com as chaves so colocados dentro de um jar.
       */
      opendreamsProxy
        .setPrivatekey(getClass().getResourceAsStream(
          opendreamsProxy.getProperties()
            .getProperty("openbus.acs.private.key")));
      opendreamsProxy
        .setACSCertificate(getClass().getResourceAsStream(
          opendreamsProxy.getProperties()
            .getProperty("openbus.acs.certificate")));
      /* Inicia a conexo com o barramento e com o servio OpenDreams */
      opendreamsProxy.init();
      /* Recupera a referncia para o servio OpenDreams */
      System.out.println("** Recuperando o componente OpenDreams...");
      IOpenDreams opendreams = opendreamsProxy.getIOpenDreams();
      Session session = opendreams.getSession(opendreamsProxy.getProjectName());
      session.init("");
      OpenDreamsJobTemplate jt =
        (OpenDreamsJobTemplate) session.createJobTemplate();
      jt.remoteCommand = "execAlgo";
      jt.args =
        new String[] { "-name", "Teste_da_SimpleDemoOpenDreams", "-version",
            "1.0.0" };
      jt.jobDescription = "Teste da Demo Simples do OpenDreams";
      jt.jobParameters = new String[][] { { "qtde", "3" }, { "duracao", "2" } };
      jt.outputPath = "saida.out";
      jt.email = new String[] { "mjulia@tecgraf.puc-rio.br" };
      System.out.println("** Solicitando a execucao de " + jt.remoteCommand);
      System.out.print("** Argumentos: ");
      for (String arg : jt.args) {
        System.out.print(arg);
        System.out.print(" ");
      }
      System.out.println();
      System.out.println("** Parametros: ");
      for (String[] parameters : jt.jobParameters) {
        System.out.println(parameters[0] + "=" + parameters[1]);
      }
      System.out.println("** OutputPath: " + jt.outputPath);
      String jobName = session.runJob(jt);
      System.out.println("** Id do comando: " + jobName);
      session.deleteJobTemplate(jt);

      OpenDreamsJobInfo jobInfo =
        (OpenDreamsJobInfo) session
          ._wait(jobName, Session.TIMEOUT_WAIT_FOREVER);
      System.out.println("** Resultado: hasExited = " + jobInfo.hasExited
        + ": exitStatus = " + jobInfo.exitStatus);
      System.out.println("** Tipo de finalizacao: " + jobInfo.finalizationType);

      Project project = opendreamsProxy.getProject();
      byte[] buffer = project.getDataFrom("saida.out");
      System.out.println("** O log de saida do comando e':");
      System.out.println(new String(buffer));
      session.exit();
    }
    catch (OpenDreamsException e) {
      e.printStackTrace();
    }
    catch (AuthorizationException e) {
      handleException(e.message, e);
    }
    catch (InternalException e) {
      handleException(e.message, e);
    }
    catch (InvalidContactStringException e) {
      handleException(e.message, e);
    }
    catch (NoDefaultContactStringSelectedException e) {
      handleException(e.message, e);
    }
    catch (DefaultContactStringException e) {
      handleException(e.message, e);
    }
    catch (DrmCommunicationException e) {
      handleException(e.message, e);
    }
    catch (DrmsInitException e) {
      handleException(e.message, e);
    }
    catch (AlreadyActiveSessionException e) {
      handleException(e.message, e);
    }
    catch (OutOfMemoryException e) {
      handleException(e.message, e);
    }
    catch (InvalidArgumentException e) {
      handleException(e.message, e);
    }
    catch (TryLaterException e) {
      handleException(e.message, e);
    }
    catch (NoActiveSessionException e) {
      handleException(e.message, e);
    }
    catch (DeniedByDrmException e) {
      handleException(e.message, e);
    }
    catch (InvalidJobTemplateException e) {
      handleException(e.message, e);
    }
    catch (InvalidJobException e) {
      handleException(e.message, e);
    }
    catch (ExitTimeoutException e) {
      handleException(e.message, e);
    }
    catch (DrmsExitException e) {
      handleException(e.message, e);
    }
    finally {
      if (opendreamsProxy != null) {
        opendreamsProxy.close();
      }
    }
  }

  private void handleException(String message, Exception e) {
    e.initCause(new Exception(message));
    e.printStackTrace();
  }
}
