import opendreams.proxy.OpenDreamsException;
import opendreams.proxy.OpenDreamsProxy;
import opendreams.proxy.Project;
import tecgraf.openbus.DRMAA.AlreadyActiveSessionException;
import tecgraf.openbus.DRMAA.AuthorizationException;
import tecgraf.openbus.DRMAA.DefaultContactStringException;
import tecgraf.openbus.DRMAA.DeniedByDrmException;
import tecgraf.openbus.DRMAA.DrmCommunicationException;
import tecgraf.openbus.DRMAA.DrmsExitException;
import tecgraf.openbus.DRMAA.DrmsInitException;
import tecgraf.openbus.DRMAA.ExitTimeoutException;
import tecgraf.openbus.DRMAA.InternalException;
import tecgraf.openbus.DRMAA.InvalidArgumentException;
import tecgraf.openbus.DRMAA.InvalidContactStringException;
import tecgraf.openbus.DRMAA.InvalidJobException;
import tecgraf.openbus.DRMAA.InvalidJobTemplateException;
import tecgraf.openbus.DRMAA.JobInfo;
import tecgraf.openbus.DRMAA.NoActiveSessionException;
import tecgraf.openbus.DRMAA.NoDefaultContactStringSelectedException;
import tecgraf.openbus.DRMAA.OutOfMemoryException;
import tecgraf.openbus.DRMAA.Session;
import tecgraf.openbus.DRMAA.TryLaterException;
import tecgraf.openbus.opendreams.IOpenDreams;
import tecgraf.openbus.opendreams.OpenDreamsJobTemplate;

/**
 * Demo de execuo de um algoritmo que recebe um parmetro de arquivo como
 * entrada e um parmetro de arquivo de sada.
 * 
 * @author Tecgraf PUC-Rio
 * 
 */
public class ProjectDemoOpenDreams {

  /**
   * Executa o teste.
   * 
   * @param args argumentos da linha de comando. No possui argumentos de
   *        entrada.
   */
  public static void main(String[] args) {
    try {
      new ProjectDemoOpenDreams().run();
    }
    catch (Throwable e) {
      e.printStackTrace();
    }
    System.exit(0);
  }

  private void run() {
    OpenDreamsProxy opendreamsProxy = null;
    try {
      /* Constroi o proxy usando as propriedades do arquivo default */
      opendreamsProxy = new OpenDreamsProxy();
      opendreamsProxy.init();
      System.out.println("** Recuperando o componente OpenDreams...");
      Project project = opendreamsProxy.getProject();
      if (project == null) {
        System.out.println("Projeto no encontrado");
        return;
      }
      /*
       * Criando um arquivo de entrada no projeto. Se o arquivo j existir, ele
       *  removido antes de ser criado um novo.
       */
      String inputFileName = "Entrada.txt";
      if (project.hasFile(inputFileName)) {
        System.out.println("** Removendo o arquivo " + inputFileName
          + " que j existe");
        project.removeFile(inputFileName);
      }
      String content = "Teste de escrita em arquivo\n";
      System.out.println("** Criando um arquivo no projeto...");
      project.createFile(inputFileName, content.getBytes());

      /*
       * Removendo um arquivo de sada no projeto, no caso dele j existir.
       */
      String outputFileName = "Saida.txt";
      if (project.hasFile(outputFileName)) {
        System.out.println("** Removendo o arquivo " + outputFileName
          + " que j existe");
        project.removeFile(outputFileName);
      }

      /*
       * Executando o algoritmo "Teste_da_Demo_de_Projeto" que copia n vezes o
       * contedo de um arquivo de entrada para outro de sada.
       */
      IOpenDreams opendreams = opendreamsProxy.getIOpenDreams();
      Session session = opendreams.getSession(opendreamsProxy.getProjectName());
      session.init("");
      OpenDreamsJobTemplate jt =
        (OpenDreamsJobTemplate) session.createJobTemplate();
      jt.remoteCommand = "execAlgo";
      jt.args =
        new String[] { "-name", "Teste da ProjectDemoOpenDreams", "-version",
            "1.0.0" };
      jt.jobDescription = "Teste do Acesso ao Projeto";
      jt.jobParameters =
        new String[][] { { "qtde", "6" },
            { "arq_entrada", "Entrada.txt:TEXT" },
            { "arq_saida", "Saida.txt:TEXT" } };
      jt.outputPath = "stdout";
      //jt.setEmail(new String[]{"mjulia@tecgraf.puc-rio.br"});
      System.out.println("** Solicitando a execucao de " + jt.remoteCommand);
      System.out.print("** Argumentos: ");
      for (String arg : jt.args) {
        System.out.print(arg);
        System.out.print(" ");
      }
      System.out.println("** Parmetros: ");
      for (String[] parameters : jt.jobParameters) {
        System.out.println(parameters[0] + "=" + parameters[1]);
      }
      System.out.println("** OutputPath: " + jt.outputPath);
      String jobName = session.runJob(jt);
      System.out.println("** Id do comando: " + jobName);
      session.deleteJobTemplate(jt);

      JobInfo jobInfo = session._wait(jobName, Session.TIMEOUT_WAIT_FOREVER);
      System.out.println("** Resultado: hasExited = " + jobInfo.hasExited
        + ": exitStatus = " + jobInfo.exitStatus);

      byte[] buffer = project.getDataFrom("stdout");
      System.out.println("** O log de sada do comando :");
      System.out.println(new String(buffer));
      session.exit();
    }
    catch (OpenDreamsException e) {
      e.printStackTrace();
    }
    catch (AuthorizationException e) {
      handleException(e.message, e);
    }
    catch (InternalException e) {
      handleException(e.message, e);
    }
    catch (InvalidContactStringException e) {
      handleException(e.message, e);
    }
    catch (NoDefaultContactStringSelectedException e) {
      handleException(e.message, e);
    }
    catch (DefaultContactStringException e) {
      handleException(e.message, e);
    }
    catch (DrmCommunicationException e) {
      handleException(e.message, e);
    }
    catch (DrmsInitException e) {
      handleException(e.message, e);
    }
    catch (AlreadyActiveSessionException e) {
      handleException(e.message, e);
    }
    catch (OutOfMemoryException e) {
      handleException(e.message, e);
    }
    catch (InvalidArgumentException e) {
      handleException(e.message, e);
    }
    catch (TryLaterException e) {
      handleException(e.message, e);
    }
    catch (NoActiveSessionException e) {
      handleException(e.message, e);
    }
    catch (DeniedByDrmException e) {
      handleException(e.message, e);
    }
    catch (InvalidJobTemplateException e) {
      handleException(e.message, e);
    }
    catch (InvalidJobException e) {
      handleException(e.message, e);
    }
    catch (ExitTimeoutException e) {
      handleException(e.message, e);
    }
    catch (DrmsExitException e) {
      handleException(e.message, e);
    }
    finally {
      if (opendreamsProxy != null) {
        opendreamsProxy.close();
      }
    }
  }

  private void handleException(String message, Exception e) {
    e.initCause(new Exception(message));
    e.printStackTrace();
  }
}
