import java.util.Iterator;
import java.util.List;

import opendreams.proxy.OpenDreamsProxy;
import opendreams.proxy.Project;

/**
 * Demo para navegao nos arquivos e diretrios existentes em todos os projetos
 * de um usurio.
 * 
 * @author Tecgraf PUC-Rio
 */
public class NavigateProjectDemoOpenDreams {

  private static final int IDENT = 3;
  
  /**
   * Executa o teste.
   * 
   * @param args argumentos da linha de comando. No possui argumentos de
   *        entrada.
   */
  public static void main(String[] args) {
    try {
      new NavigateProjectDemoOpenDreams().run();
    }
    catch (Throwable e) {
      e.printStackTrace();
    }
    System.exit(0);
  }

  private void run() throws Exception {
    System.out.println("** Recuperando o componente OpenDreams...");

    // inicializa acesso ao barramento
    OpenDreamsProxy opendreamsProxy = new OpenDreamsProxy();
    //opendreamsProxy.init("uid=lmachado,ou=Tecgraf", "");
    opendreamsProxy.init();

    // obtm a lista de projetos do usurio
    List<Project> allProjects = opendreamsProxy.getAllProjects();

    // para cada projeto, exibe os arquivos e diretrios no diretrio corrente
    for (Iterator<Project> iterator = allProjects.iterator(); iterator
      .hasNext();) {
      Project project = iterator.next();
      System.out.println("** Lista de arquivos e diretrios do projeto: "
        + project.getName());
      for (String fileName : project.list()) {
        showChild(project, fileName, IDENT);
      }
    }

    // fecha a conexo 
    opendreamsProxy.close();
  }
  
  private void showChild(Project project, String childName, int count) throws Exception {
    StringBuffer ident = new StringBuffer();
    for (int i=0; i<count; i++) {
      ident.append(' ');
    }
    if (project.isDirectory(childName)) {
      project.changeDirectory(childName);
      System.out.println(ident+"+ Diretorio: " + childName);
      for (String fileName : project.list()) {
        showChild(project, fileName, count+IDENT);
      }
      project.changeDirectoryUp();
    } else {
      System.out.println(ident+"- Arquivo: " + childName);
    }
  }
}