import opendreams.proxy.OpenDreamsException;
import opendreams.proxy.OpenDreamsProxy;
import tecgraf.openbus.DRMAA.AlreadyActiveSessionException;
import tecgraf.openbus.DRMAA.AuthorizationException;
import tecgraf.openbus.DRMAA.DefaultContactStringException;
import tecgraf.openbus.DRMAA.DeniedByDrmException;
import tecgraf.openbus.DRMAA.DrmCommunicationException;
import tecgraf.openbus.DRMAA.DrmsExitException;
import tecgraf.openbus.DRMAA.DrmsInitException;
import tecgraf.openbus.DRMAA.InternalException;
import tecgraf.openbus.DRMAA.InvalidArgumentException;
import tecgraf.openbus.DRMAA.InvalidContactStringException;
import tecgraf.openbus.DRMAA.InvalidJobException;
import tecgraf.openbus.DRMAA.InvalidJobTemplateException;
import tecgraf.openbus.DRMAA.JobState;
import tecgraf.openbus.DRMAA.NoActiveSessionException;
import tecgraf.openbus.DRMAA.NoDefaultContactStringSelectedException;
import tecgraf.openbus.DRMAA.OutOfMemoryException;
import tecgraf.openbus.DRMAA.Session;
import tecgraf.openbus.DRMAA.TryLaterException;
import tecgraf.openbus.opendreams.IOpenDreams;
import tecgraf.openbus.opendreams.OpenDreamsJobTemplate;

/**
 * Demo do OpenDreams.
 * 
 * Essa demo submete um comando e usa o jobStatus para acompanhar sua execuo.
 * Permite como parmetro de entrada o id de um job e, nesse caso, no submete
 * nenhum comando e fica apenas acompanhando os estados desse job por meio de
 * chamadas ao mtodo jobStatus.
 * 
 * @author Tecgraf PUC-Rio
 * 
 */
public class JobStatusDemoOpenDreams {
  /**
   * Executa o teste.
   * 
   * @param args argumentos da linha de comando. No possui argumentos de
   *        entrada.
   * @throws Exception se ocorrer alguma falha na execuo do teste
   */
  public static void main(String[] args) throws Exception {
    String jobName = null;
    if (args != null && args.length > 0) {
      jobName = args[0];
      System.out.println("** jobName=" + jobName);
    }
    new JobStatusDemoOpenDreams().run(jobName);
  }

  private void run(String jobName) {
    OpenDreamsProxy opendreamsProxy = null;
    try {
      /* Constroi o proxy usando as propriedades do arquivo default */
      opendreamsProxy = new OpenDreamsProxy();
      /* Inicia a conexo com o barramento e com o servio OpenDreams */
      opendreamsProxy.init();
      /* Recupera a referncia para o servio OpenDreams */
      System.out.println("** Recuperando o componente OpenDreams...");
      IOpenDreams opendreams = opendreamsProxy.getIOpenDreams();
      Session session = opendreams.getSession(opendreamsProxy.getProjectName());
      session.init("");
      /* Se no recebeu um jobname como parmetro de entrada, submete um comando */
      if (jobName == null) {
        OpenDreamsJobTemplate jt =
          (OpenDreamsJobTemplate) session.createJobTemplate();
        jt.remoteCommand = "execAlgo";
        jt.args =
          new String[] { "-name", "Teste_da_SimpleDemoOpenDreams", "-version",
              "1.0.0" };
        jt.jobDescription = "Teste da Demo Simples do OpenDreams";
        jt.jobParameters =
          new String[][] { { "qtde", "6" }, { "duracao", "3" } };
        jt.outputPath = "saida.out";
        jt.email = new String[] { "mjulia@tecgraf.puc-rio.br" };
        System.out.println("** Solicitando a execucao de " + jt.remoteCommand);
        System.out.print("** Argumentos: ");
        for (String arg : jt.args) {
          System.out.print(arg);
          System.out.print(" ");
        }
        System.out.println("** Parmetros: ");
        for (String[] parameters : jt.jobParameters) {
          System.out.println(parameters[0] + "=" + parameters[1]);
        }
        System.out.println("** OutputPath: " + jt.outputPath);
        jobName = session.runJob(jt);
        System.out.println("** Id do comando: " + jobName);
        session.deleteJobTemplate(jt);
      }
      /*
       * Monitora os estados do comando at que ele se torne DONE, FAILED ou
       * UNDETERMINED
       */
      JobState state = null;
      while (state == null
        || (!state.equals(JobState.DONE) && !state.equals(JobState.FAILED) && !state
          .equals(JobState.UNDETERMINED))) {
        JobState newstate = session.jobStatus(jobName);
        if (!newstate.equals(state)) {
          state = newstate;
          System.out.print("\n** jobstatus: " + state.toString());
        }
        else {
          System.out.print(".");
        }
      }
      session.exit();
    }
    catch (OpenDreamsException e) {
      e.printStackTrace();
    }
    catch (AuthorizationException e) {
      handleException(e.message, e);
    }
    catch (InternalException e) {
      handleException(e.message, e);
    }
    catch (InvalidContactStringException e) {
      handleException(e.message, e);
    }
    catch (NoDefaultContactStringSelectedException e) {
      handleException(e.message, e);
    }
    catch (DefaultContactStringException e) {
      handleException(e.message, e);
    }
    catch (DrmCommunicationException e) {
      handleException(e.message, e);
    }
    catch (DrmsInitException e) {
      handleException(e.message, e);
    }
    catch (AlreadyActiveSessionException e) {
      handleException(e.message, e);
    }
    catch (OutOfMemoryException e) {
      handleException(e.message, e);
    }
    catch (InvalidArgumentException e) {
      handleException(e.message, e);
    }
    catch (TryLaterException e) {
      handleException(e.message, e);
    }
    catch (NoActiveSessionException e) {
      handleException(e.message, e);
    }
    catch (DeniedByDrmException e) {
      handleException(e.message, e);
    }
    catch (InvalidJobTemplateException e) {
      handleException(e.message, e);
    }
    catch (InvalidJobException e) {
      handleException(e.message, e);
    }
    catch (DrmsExitException e) {
      handleException(e.message, e);
    }
    finally {
      if (opendreamsProxy != null) {
        opendreamsProxy.close();
      }
    }
  }

  private void handleException(String message, Exception e) {
    e.initCause(new Exception(message));
    e.printStackTrace();
  }
}
